/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.maven.plugin.MojoFailureException;
import org.mule.extension.maven.ExtensionMojoUtils;
import org.mule.extension.maven.generator.GenerationContext;
import org.mule.runtime.extension.api.ExtensionWalker;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.operation.HasOperationModels;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.source.HasSourceModels;
import org.mule.runtime.extension.api.introspection.source.SourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioIconsGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StudioIconsGenerator.class);
    private static final String ICONS_FOLDER = "/icons";
    private static final String LARGE = "large";
    private static final String SMALL = "small";
    private static final String LIGHT_THEME = "theme.light";
    private static final String CLASSIC_THEME = "theme.classic";
    private static final String CONNECTOR = "%s-connector-";
    private static final String ENDPOINT = "%s-endpoint-";
    private static final String PNG_EXTENSION = ".png";
    private static final String SUFFIX_CONNECTOR_SMALL_PNG = "%s-connector-small.png";
    private static final String SUFFIX_CONNECTOR_LARGE_PNG = "%s-connector-large.png";
    private static final String SUFFIX_ENDPOINT_SMALL_PNG = "%s-endpoint-small.png";
    private static final String SUFFIX_ENDPOINT_LARGE_PNG = "%s-endpoint-large.png";
    private static final List<String> reservedFolderNames = Arrays.asList("theme.light", "theme.classic");
    private static final String PATH_SEPARATOR = "/";
    private final ExtensionModel extensionModel;
    private final GenerationContext context;
    private final File projectBasedir;

    public StudioIconsGenerator(GenerationContext context) {
        this.projectBasedir = context.getMavenProject().getBasedir();
        this.extensionModel = context.getExtensionModel();
        this.context = context;
    }

    public void generate() throws MojoFailureException {
        try {
            File iconsFolder = new File(this.context.getPluginOutputDirectory(), ICONS_FOLDER);
            ExtensionMojoUtils.createDirectoryIfNotExist(iconsFolder);
            ExtensionMojoUtils.createDirectoryIfNotExist(new File(iconsFolder, LIGHT_THEME));
            ExtensionMojoUtils.createDirectoryIfNotExist(new File(iconsFolder, CLASSIC_THEME));
            final AtomicReference<Boolean> hasOperations = new AtomicReference<Boolean>(false);
            final AtomicReference<Boolean> hasSources = new AtomicReference<Boolean>(false);
            new ExtensionWalker(){

                public void onOperation(HasOperationModels owner, OperationModel model) {
                    hasOperations.set(true);
                }

                public void onSource(HasSourceModels owner, SourceModel model) {
                    hasSources.set(true);
                }
            }.walk(this.extensionModel);
            if (hasOperations.get().booleanValue()) {
                this.createOperationIcon(iconsFolder);
            }
            if (hasSources.get().booleanValue()) {
                this.createSourceIcon(iconsFolder);
            }
            this.copyThemesFolders(iconsFolder);
        }
        catch (Exception e) {
            throw new MojoFailureException("An error occurred generating extensions Icons", (Throwable)e);
        }
    }

    private void createSourceIcon(File iconsFolder) throws IOException {
        this.copyIcon("theme.classic/%s-endpoint-large.png", iconsFolder);
        this.copyIcon("theme.classic/%s-endpoint-small.png", iconsFolder);
        this.copyIcon("theme.light/%s-endpoint-large.png", iconsFolder);
        this.copyIcon("theme.light/%s-endpoint-small.png", iconsFolder);
    }

    private void createOperationIcon(File iconsFolder) throws IOException {
        this.copyIcon("theme.classic/%s-connector-small.png", iconsFolder);
        this.copyIcon("theme.classic/%s-connector-large.png", iconsFolder);
        this.copyIcon("theme.light/%s-connector-small.png", iconsFolder);
        this.copyIcon("theme.light/%s-connector-large.png", iconsFolder);
    }

    private void copyIcon(String baseIconName, File iconsFolder) throws IOException {
        String extensionIconName = String.format(baseIconName, this.context.getExtensionPluginName());
        File extensionIcon = new File(this.projectBasedir, "/icons/" + extensionIconName);
        File destFile = new File(iconsFolder.getPath() + PATH_SEPARATOR + extensionIconName);
        if (extensionIcon.exists()) {
            Files.copy(extensionIcon.toPath(), destFile.toPath(), new CopyOption[0]);
        } else {
            LOGGER.warn(String.format("The icon [%s] was not found in the 'icons' folder. A generic one will be used instead.", extensionIconName));
            String genericIcon = String.format(baseIconName, "generic");
            InputStream resource = StudioIconsGenerator.class.getClassLoader().getResourceAsStream(genericIcon);
            Files.copy(resource, destFile.toPath(), new CopyOption[0]);
        }
    }

    private void copyThemesFolders(File destIconsFolder) throws IOException {
        File extensionIconsFolder = new File(this.projectBasedir, ICONS_FOLDER);
        if (extensionIconsFolder.exists()) {
            File[] themeFolders;
            for (File themeFolder : themeFolders = extensionIconsFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
                if (this.isReservedFolderName(themeFolder)) continue;
                FileUtils.copyDirectory((File)themeFolder, (File)new File(destIconsFolder, themeFolder.getName()));
            }
        }
    }

    private boolean isReservedFolderName(File themeFolder) {
        return reservedFolderNames.contains(themeFolder.getName());
    }
}

