/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import java.io.File;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.mule.extension.maven.generator.GenerationContext;
import org.mule.runtime.extension.api.Category;

public class PluginJarGenerator {
    private final GenerationContext context;

    public PluginJarGenerator(GenerationContext context) {
        this.context = context;
    }

    public File generate() throws MojoFailureException {
        try {
            JarArchiver archiver = new JarArchiver();
            File classesDirectory = this.context.getClassesDirectory();
            File outputDirectory = this.context.getOutputDirectory();
            String extensionZipName = this.context.getArtifactName() + ".zip";
            String sourcesJarName = this.context.getArtifactName() + "-sources.jar";
            String javadocJarName = this.context.getArtifactName() + "-javadoc.jar";
            archiver.addFile(new File(outputDirectory, extensionZipName), extensionZipName);
            if (this.context.getExtensionCategory().equals((Object)Category.COMMUNITY)) {
                this.addIfExist((Archiver)archiver, sourcesJarName, outputDirectory);
            }
            this.addIfExist((Archiver)archiver, javadocJarName, outputDirectory);
            archiver.setManifest(new File(classesDirectory, this.context.getExtensionPluginName() + "/META-INF/MANIFEST.MF"));
            archiver.addDirectory(new File(classesDirectory, this.context.getExtensionPluginName()));
            File pluginJar = new File(outputDirectory, "update-site/plugins/" + this.context.getPluginJarName());
            archiver.setDestFile(pluginJar);
            archiver.createArchive();
            return pluginJar;
        }
        catch (Exception e) {
            throw new MojoFailureException("An error occurred generating the extension plugin JAR", (Throwable)e);
        }
    }

    private void addIfExist(Archiver archiver, String sourcesJarName, File outputDirectory) {
        File sourcesJar = new File(outputDirectory, sourcesJarName);
        if (sourcesJar.exists()) {
            archiver.addFile(sourcesJar, sourcesJarName);
        }
    }
}

