/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import org.apache.maven.project.MavenProject;
import org.mule.extension.maven.ExtensionMojoUtils;
import org.mule.runtime.api.MuleVersion;
import org.mule.runtime.extension.api.Category;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.mule.runtime.extension.xml.dsl.api.property.XmlModelProperty;

public final class GenerationContext {
    private static final String STUDIO_PREFIX = "org.mule.tooling.ui.extension.";
    private static final String STUDIO_CONTRIBUTION = "org.mule.tooling.ui.contribution";
    private static final SimpleDateFormat STUDIO_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    private final String artifactName;
    private final String bundleVersion;
    private final String featureId;
    private final String featureJarName;
    private final String extensionPluginName;
    private final String pluginJarName;
    private final String symbolicName;
    private final MavenProject project;
    private final Category extensionCategory;
    private final ExtensionManifest manifest;
    private final ExtensionModel extensionModel;
    private final File outputDirectory;
    private final File classesDirectory;
    private final File pluginOutputDirectory;

    public GenerationContext(MavenProject project, ExtensionManifest manifest, ExtensionModel extensionModel, File outputDirectory) throws IOException {
        this.project = project;
        this.manifest = manifest;
        this.extensionModel = extensionModel;
        String completeMinMuleVersion = extensionModel.getMinMuleVersion().toCompleteNumericVersion();
        this.bundleVersion = GenerationContext.buildVersion(project.getVersion());
        this.extensionPluginName = this.getExtensionNamespace(extensionModel).orElse(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, manifest.getName().replaceAll(" ", "")));
        this.featureId = STUDIO_PREFIX + this.removeMuleModulePrefix(project.getArtifactId()) + "." + completeMinMuleVersion;
        this.featureJarName = this.featureId + "_" + this.bundleVersion + ".jar";
        this.symbolicName = "org.mule.tooling.ui.contribution." + this.extensionPluginName + "." + completeMinMuleVersion;
        this.pluginJarName = this.symbolicName + "_" + this.bundleVersion + ".jar";
        this.artifactName = project.getArtifactId() + "-" + project.getVersion();
        this.extensionCategory = extensionModel.getCategory();
        this.outputDirectory = outputDirectory;
        this.classesDirectory = new File(outputDirectory, "classes");
        this.pluginOutputDirectory = new File(this.classesDirectory, this.extensionPluginName);
        ExtensionMojoUtils.createDirectoryIfNotExist(this.pluginOutputDirectory);
    }

    private static String buildVersion(String version) {
        String completeNumericVersion = new MuleVersion(version).toCompleteNumericVersion();
        String versionQualifier = STUDIO_DATE_FORMAT.format(new Date());
        return completeNumericVersion + "." + versionQualifier;
    }

    public String getExtensionPluginName() {
        return this.extensionPluginName;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public String getFeatureJarName() {
        return this.featureJarName;
    }

    public String getPluginJarName() {
        return this.pluginJarName;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public Category getExtensionCategory() {
        return this.extensionCategory;
    }

    public MavenProject getMavenProject() {
        return this.project;
    }

    public ExtensionManifest getExtensionManifest() {
        return this.manifest;
    }

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    private String removeMuleModulePrefix(String artifactId) {
        String muleModulePrefix = "mule-module-";
        if (artifactId.startsWith(muleModulePrefix)) {
            return artifactId.substring(muleModulePrefix.length());
        }
        return artifactId;
    }

    public File getPluginOutputDirectory() {
        return this.pluginOutputDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    private Optional<String> getExtensionNamespace(ExtensionModel extensionModel) {
        Optional xmlModelProperty = extensionModel.getModelProperty(XmlModelProperty.class);
        return xmlModelProperty.isPresent() ? Optional.of(((XmlModelProperty)xmlModelProperty.get()).getNamespace()) : Optional.empty();
    }
}

