/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import java.io.File;
import java.net.URLDecoder;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.mule.extension.maven.generator.GenerationContext;

public class FeaturesAndBundlesGenerator {
    private static final String UTF_8 = "UTF-8";
    private static final String CATEGORY_XML = "category.xml";
    private final GenerationContext context;
    private final P2ApplicationLauncher launcher;
    private final P2ApplicationLauncher launcher2;
    private final String UPDATE_SITE_ERROR_MESSAGE = "Error creating update site: Return code ";

    public FeaturesAndBundlesGenerator(GenerationContext context, P2ApplicationLauncher launcher, P2ApplicationLauncher launcher2) {
        this.context = context;
        this.launcher = launcher;
        this.launcher2 = launcher2;
    }

    public void generate() throws MojoFailureException {
        try {
            String updateSiteURI;
            File categoryFile = new File(this.context.getOutputDirectory(), CATEGORY_XML).getAbsoluteFile();
            if (!categoryFile.exists()) {
                throw new MojoFailureException(String.format("Update Site: '%s' does not exist in [%s]", CATEGORY_XML, categoryFile.getParentFile()));
            }
            String categoryXmlURI = URLDecoder.decode(categoryFile.toURI().toString(), UTF_8);
            File updateSitePath = new File(this.context.getOutputDirectory(), "update-site");
            int returnCode = this.featuresAndBundles(this.launcher, updateSitePath, updateSiteURI = URLDecoder.decode(updateSitePath.toURI().toString(), UTF_8));
            if (returnCode != 0) {
                throw new MojoFailureException("Error creating update site: Return code " + returnCode);
            }
            returnCode = this.categoryPublisher(this.launcher2, updateSiteURI, categoryXmlURI);
            if (returnCode != 0) {
                throw new MojoFailureException("Error creating update site: Return code " + returnCode);
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Error occurred populating the Update Site", (Throwable)e);
        }
    }

    private int featuresAndBundles(P2ApplicationLauncher launcher, File updateSitePath, String updateSiteURI) {
        launcher.addArguments(new String[]{"-artifactRepository", updateSiteURI});
        launcher.addArguments(new String[]{"-metadataRepository", updateSiteURI});
        launcher.addArguments(new String[]{"-source", updateSitePath.getAbsolutePath()});
        launcher.addArguments(new String[]{"-publishArtifacts", "-append"});
        launcher.setApplicationName("org.eclipse.equinox.p2.publisher.FeaturesAndBundlesPublisher");
        return launcher.execute(20);
    }

    private int categoryPublisher(P2ApplicationLauncher launcher, String updateSiteURI, String categoryXmlURI) {
        launcher.addArguments(new String[]{"-categoryDefinition", categoryXmlURI});
        launcher.addArguments(new String[]{"-categoryQualifier"});
        launcher.addArguments(new String[]{"-metadataRepository", updateSiteURI});
        launcher.setApplicationName("org.eclipse.equinox.p2.publisher.CategoryPublisher");
        return launcher.execute(20);
    }
}

