/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import java.io.File;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.mule.extension.maven.generator.GenerationContext;
import org.mule.extension.maven.generator.MavenLicense;
import org.mule.extension.maven.generator.MavenLicenseBuilder;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StudioFeatureGenerator {
    private static final String FEATURE_XML_FILENAME = "feature.xml";
    private final MavenProject project;
    private final ExtensionManifest manifest;
    private final ExtensionModel extensionModel;
    private final GenerationContext context;

    public StudioFeatureGenerator(GenerationContext context) {
        this.project = context.getMavenProject();
        this.manifest = context.getExtensionManifest();
        this.extensionModel = context.getExtensionModel();
        this.context = context;
    }

    public void generate() throws MojoFailureException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element feature = document.createElement("feature");
            feature.setAttribute("id", this.context.getFeatureId());
            feature.setAttribute("label", this.getLabel(this.manifest));
            feature.setAttribute("version", this.context.getBundleVersion());
            feature.setAttribute("provider-name", this.extensionModel.getVendor());
            document.appendChild(feature);
            Element licenseElement = document.createElement("license");
            this.populateLicense(licenseElement);
            feature.appendChild(licenseElement);
            Element plugin = document.createElement("plugin");
            plugin.setAttribute("id", this.context.getSymbolicName());
            plugin.setAttribute("download-size", "0");
            plugin.setAttribute("install-size", "0");
            plugin.setAttribute("version", this.context.getBundleVersion());
            plugin.setAttribute("unpack", "true");
            feature.appendChild(plugin);
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(this.context.getOutputDirectory(), FEATURE_XML_FILENAME));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error generating Mule Studio 'feature.xml' file", (Throwable)e);
        }
    }

    private void populateLicense(Element licenseElement) {
        Optional<String> optionalLicense;
        MavenLicense mavenLicense = new MavenLicenseBuilder(this.project.getBasedir(), this.project.getLicenses()).build();
        Optional<String> url = mavenLicense.getUrl();
        if (url.isPresent()) {
            licenseElement.setAttribute("url", url.get());
        }
        if ((optionalLicense = mavenLicense.getLicenseBody()).isPresent()) {
            String licenseBody = optionalLicense.get();
            licenseElement.setTextContent(licenseBody);
            licenseElement.setNodeValue(licenseBody);
        }
    }

    private String getLabel(ExtensionManifest manifest) {
        return String.format("%s Extension (Mule %s+)", manifest.getName(), manifest.getMinMuleVersion().toCompleteNumericVersion());
    }
}

