/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import sun.security.tools.jarsigner.Main;

public class ComponentSigner {
    private static final int OPTIONS_ARRAY_CAPACITY = 11;
    private final String keystorePath;
    private final String storepass;
    private final String keypass;
    private final String alias;
    private final String tsaUrl;

    public ComponentSigner(String keystorePath, String storepass, String keypass, String alias, String tsaUrl) {
        if (keystorePath == null) {
            throw new IllegalArgumentException("Keystore Path can not be null");
        }
        if (!new File(keystorePath).exists()) {
            throw new IllegalArgumentException("The given Keystore [%s] doesn't");
        }
        this.keystorePath = keystorePath;
        this.storepass = storepass;
        this.keypass = keypass;
        this.alias = alias;
        this.tsaUrl = tsaUrl;
    }

    public void sign(File jarFile) {
        List<String> jarSignerParameters = this.buildParametersList(jarFile.getPath());
        try {
            Main.main(jarSignerParameters.toArray(new String[11]));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not sign the generated jar file.", e);
        }
    }

    private List<String> buildParametersList(String path) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-keystore");
        options.add(this.keystorePath);
        if (this.storepass != null) {
            options.add("-storepass");
            options.add(this.storepass);
        }
        if (this.keypass != null) {
            options.add("-keypass");
            options.add(this.keypass);
        }
        if (this.tsaUrl != null) {
            options.add("-tsa");
            options.add(this.tsaUrl);
        }
        options.add("-verbose");
        options.add(path);
        options.add(this.alias);
        return options;
    }
}

