package org.mule.extension.maven.generator;

import java.io.File;

import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

/**
 * This packager takes the generated 'update-site' folder and compress it into a ZIP with the name of the extension
 * artifact and with the 'studio-plugin' artifact classifier, Example: 'mule-module-http-4.0.0-studio-plugin.zip'.
 * <p>
 * The generated artifact is attached to the maven cycle.
 *
 * @since 1.0
 */
public class StudioPluginZipGenerator
{

    private static final String STUDIO_PLUGIN = "studio-plugin";
    private final GenerationContext context;
    private final MavenProjectHelper projectHelper;

    public StudioPluginZipGenerator(GenerationContext context, MavenProjectHelper projectHelper)
    {

        this.context = context;
        this.projectHelper = projectHelper;
    }

    public void generate() throws MojoFailureException
    {
        try
        {
            ZipArchiver zipArchiver = new ZipArchiver();
            zipArchiver.addDirectory(new File(context.getOutputDirectory(), "update-site"));

            final File updateSiteZipFile = new File(context.getOutputDirectory(), context.getArtifactName() + "-" + STUDIO_PLUGIN + ".zip");
            zipArchiver.setDestFile(updateSiteZipFile);
            zipArchiver.createArchive();

            //Important: This is the name that the Nexus Update Site Plugin uses to find the artifact.
            //Be careful changing how the artifact will be found.
            projectHelper.attachArtifact(context.getMavenProject(), "zip", STUDIO_PLUGIN, updateSiteZipFile);
        }
        catch (Exception e)
        {
            throw new MojoFailureException("An error occurred packaging the extension Update Site", e);
        }
    }
}
