/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.extension.maven.generator;

import static com.google.common.io.Files.createParentDirs;

import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoFailureException;

/**
 * Generator for OSGi bundle 'MANIFEST.MF' file
 * <p>
 * The 'MANIFEST.MF' contains the required headers that describes the OSGi bundle of the extension for Studio
 *
 * @since 1.0
 */
public class StudioManifestGenerator
{

    private final ExtensionManifest manifest;
    private final ExtensionModel extensionModel;
    private final GenerationContext context;


    public StudioManifestGenerator(GenerationContext context)
    {
        this.manifest = context.getExtensionManifest();
        this.extensionModel = context.getExtensionModel();
        this.context = context;
    }

    public void generate() throws MojoFailureException
    {
        PrintStream printStream = null;

        try
        {
            final File manifestFile = new File(context.getPluginOutputDirectory(), "META-INF/MANIFEST.MF");
            createParentDirs(manifestFile);
            printStream = new PrintStream(manifestFile);
            printStream.append(getManifestContents());
            printStream.flush();
        }
        catch (IOException e)
        {
            throw new MojoFailureException("Error occurred generating 'MANIFEST.MF' file", e);
        }
        finally
        {
            IOUtils.closeQuietly(printStream);
        }
    }

    /**
     * Creates the extension's manifest
     *
     * @return the extension's manifest as {@link String}
     */
    private String getManifestContents()
    {
        return "Manifest-Version: 1.0\n" +
               "Bundle-ManifestVersion: 2\n" +
               "Bundle-Name: " + manifest.getName() + "\n" +
               "Bundle-SymbolicName: " + context.getSymbolicName() + ";singleton:=true\n" +
               "Bundle-Version: " + context.getBundleVersion() + "\n" +
               "Bundle-Vendor: " + extensionModel.getVendor() + "\n" +
               "Require-Bundle: org.eclipse.ui,\n" +
               " org.eclipse.core.runtime,\n" +
               " org.mule.tooling.core;bundle-version=\"1.0.0\"\n" +
               "Bundle-RequiredExecutionEnvironment: JavaSE-1.8\n" +
               "Bundle-ActivationPolicy: lazy\n" +
               "Eclipse-BundleShape: dir\n";
    }
}