/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.extension.maven.generator;

import java.util.Optional;

import org.apache.maven.model.License;

/**
 * POJO that saves the body and url of a {@link License}
 *
 * @since 1.0
 */
public class MavenLicense
{

    private String url;
    private String body;

    MavenLicense(String body, String url)
    {
        this.body = body;
        this.url = url;
    }

    public Optional<String> getUrl()
    {
        return Optional.ofNullable(url);
    }

    public Optional<String> getLicenseBody()
    {
        return Optional.ofNullable(body);
    }
}
