package org.mule.extension.maven.generator;

import java.io.File;

import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.jar.JarArchiver;

/**
 * Generator for extension Update Site feature JAR.
 * <p>
 * This JAR will contain the generated 'feature.xml' file and ill be saved into the 'features' folder inside the
 * generated Update Site.
 *
 * @since 1.0
 */
public class FeatureJarGenerator
{

    private static final String FEATURE_XML = "feature.xml";
    private final GenerationContext context;

    public FeatureJarGenerator(GenerationContext context)
    {
        this.context = context;
    }

    public File generate() throws MojoFailureException
    {
        JarArchiver archiver = new JarArchiver();
        try
        {
            archiver.addFile(new File(context.getOutputDirectory(), FEATURE_XML), FEATURE_XML);
            final File destFile = new File(context.getOutputDirectory(), "update-site/features/" + context.getFeatureJarName());
            archiver.setDestFile(destFile);

            archiver.createArchive();
            return destFile;
        }
        catch (Exception e)
        {
            throw new MojoFailureException("An error occurred generating the extension feature JAR", e);
        }
    }
}
