/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.mule.testing.processing.strategies.test.internal;

import java.util.concurrent.BlockingQueue;

public final class CompletionCallbacksDeferrer {

  private final BlockingQueue<CompleterTask> completionCallbacksQueue;

  public CompletionCallbacksDeferrer(BlockingQueue<CompleterTask> completionCallbacksQueue) {
    this.completionCallbacksQueue = completionCallbacksQueue;
  }

  void completeDeferred(CompleterTask completionCallback) throws InterruptedException {
    this.completionCallbacksQueue.put(completionCallback);
  }
}
