/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mule.testing.processing.strategies.test.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionThreadTracker {
    private final List<List<String>> processorsThatWereExecutedWithoutAThreadJump = new ArrayList<List<String>>();
    private static final Integer SENTINEL_VALUE = 52;
    private ThreadLocal<Integer> sentinelThreadLocal = null;
    private List<String> processorsSinceLastThreadJump;
    private static final String EXECUTION_PREFIX = "Execution";
    private static final String COMPLETION_PREFIX = "Completion";
    private final Map<String, String> threadNames = new ConcurrentHashMap<String, String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionThreadTracker.class);

    public void trackExecutionThread(String key) {
        LOGGER.info("Key [{}] executed in thread: [{}]", (Object)key, (Object)Thread.currentThread().getName());
        this.resetSentinelIfNeeded();
        this.addToCurrentPhase(ExecutionThreadTracker.execution(key));
    }

    public void trackCompletionThread(String key) {
        LOGGER.info("Key [{}] completed in thread: [{}]", (Object)key, (Object)Thread.currentThread().getName());
        this.resetSentinelIfNeeded();
        this.addToCurrentPhase(ExecutionThreadTracker.completion(key));
    }

    public Integer getExecutionThreadPhase(String key) {
        return this.search(ExecutionThreadTracker.execution(key));
    }

    public Integer getCompletionThreadPhase(String key) {
        return this.search(ExecutionThreadTracker.completion(key));
    }

    private void addToCurrentPhase(String decoratedKey) {
        this.processorsSinceLastThreadJump.add(decoratedKey);
        this.threadNames.put(decoratedKey, Thread.currentThread().getName());
    }

    private Integer search(String decoratedKey) {
        int phaseOrder = 0;
        for (List<String> phase : this.processorsThatWereExecutedWithoutAThreadJump) {
            if (phase.contains(decoratedKey)) {
                return phaseOrder;
            }
            ++phaseOrder;
        }
        if (this.processorsSinceLastThreadJump.contains(decoratedKey)) {
            return phaseOrder;
        }
        return null;
    }

    private void resetSentinelIfNeeded() {
        if (this.comingFromAThreadJump()) {
            this.setSentinel();
            this.saveProcessorsSincePreviousThreadJump();
            this.resetProcessorsList();
        }
    }

    private void resetProcessorsList() {
        this.processorsSinceLastThreadJump = new ArrayList<String>();
    }

    private void saveProcessorsSincePreviousThreadJump() {
        if (this.processorsSinceLastThreadJump != null && !this.processorsSinceLastThreadJump.isEmpty()) {
            this.processorsThatWereExecutedWithoutAThreadJump.add(this.processorsSinceLastThreadJump);
        }
    }

    private boolean comingFromAThreadJump() {
        return this.sentinelThreadLocal == null || this.sentinelThreadLocal.get() == null;
    }

    private void setSentinel() {
        this.sentinelThreadLocal = new ThreadLocal();
        this.sentinelThreadLocal.set(SENTINEL_VALUE);
    }

    private static String execution(String key) {
        return "Execution(" + key + ")";
    }

    private static String completion(String key) {
        return "Completion(" + key + ")";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String processor : this.threadNames.keySet()) {
            builder.append(processor);
            builder.append(" runs in thread: ");
            builder.append(this.threadNames.get(processor));
        }
        return builder.toString();
    }
}

