/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.mule.testing.processing.strategies.test.internal;

import static org.mule.runtime.api.meta.model.operation.ExecutionType.BLOCKING;
import static org.mule.runtime.api.meta.model.operation.ExecutionType.CPU_INTENSIVE;
import static org.mule.runtime.api.meta.model.operation.ExecutionType.CPU_LITE;
import static org.mule.runtime.extension.api.annotation.param.MediaType.TEXT_PLAIN;

import org.mule.extension.mule.testing.processing.strategies.test.api.BarrierProvider;
import org.mule.extension.mule.testing.processing.strategies.test.api.ExecutionThreadTracker;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

import javax.inject.Inject;


/**
 * This class is a container for operations, every public method in this class will be taken as an extension operation.
 */
public class MuleTestingProcessingStrategiesTestOperations {

  @Inject
  private ExecutionThreadTracker executionThreadTracker;

  @Inject
  private BarrierProvider barrierProvider;

  @Execution(CPU_LITE)
  public void cpuLiteWithoutCallback(String key) {
    executionThreadTracker.trackExecutionThread(key);
  }

  @Execution(BLOCKING)
  public void blockingWithoutCallback(String key) {
    executionThreadTracker.trackExecutionThread(key);
  }

  @Execution(CPU_INTENSIVE)
  public void cpuIntensiveWithoutCallback(String key) {
    executionThreadTracker.trackExecutionThread(key);
  }

  @MediaType(value = TEXT_PLAIN, strict = false)
  @Execution(CPU_LITE)
  public void cpuLiteWithCallback(String key,
                                  @Connection CompletionCallbacksDeferrer connection,
                                  CompletionCallback<String, Object> callback) throws InterruptedException {
    executionThreadTracker.trackExecutionThread(key);
    connection.completeDeferred(new CompleterTask(callback, key));
  }

  @MediaType(value = TEXT_PLAIN, strict = false)
  @Execution(BLOCKING)
  public void blockingWithCallback(String key,
                                   @Connection CompletionCallbacksDeferrer connection,
                                   CompletionCallback<String, Object> callback) throws InterruptedException {
    executionThreadTracker.trackExecutionThread(key);
    connection.completeDeferred(new CompleterTask(callback, key));
  }

  @MediaType(value = TEXT_PLAIN, strict = false)
  @Execution(CPU_INTENSIVE)
  public void cpuIntensiveWithCallback(String key,
                                       @Connection CompletionCallbacksDeferrer connection,
                                       CompletionCallback<String, Object> callback) throws InterruptedException {
    executionThreadTracker.trackExecutionThread(key);
    connection.completeDeferred(new CompleterTask(callback, key));
  }

  public void barrier(String name) throws InterruptedException {
    barrierProvider.get(name).block();
  }
}
