/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.mule.testing.processing.strategies.test.internal;

import org.mule.extension.mule.testing.processing.strategies.test.api.ExecutionThreadTracker;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

public class CompleterTask {

    private final CompletionCallback<String, Object> completionCallback;
    private final String key;

    public CompleterTask(CompletionCallback<String, Object> completionCallback, String name) {
        this.completionCallback = completionCallback;
        this.key = name;
    }

    public void complete(ExecutionThreadTracker executionThreadTracker) {
        completionCallback.success(Result.<String, Object>builder().output("Completing operation [" + key + "]").build());
        executionThreadTracker.trackCompletionThread(key);
    }
}
