/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package requesterpj.internal.operation;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.connectivity.rest.commons.api.config.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;

import java.io.InputStream;

import requesterpj.internal.connection.RequesterConnection;
import requesterpj.internal.metadata.HttpRequesterOutputResolver;
import requesterpj.internal.metadata.ValuesParameterHttpRequesterOperation;

public class HttpRequesterOperation extends BaseRestOperation {

    private static final String APPLICATION_JSON = "application/json";

    @MediaType(APPLICATION_JSON)
    @OutputResolver(
        output = HttpRequesterOutputResolver.class)
    @Throws(RestErrorTypeProvider.class)
    public void getHttp(
        @Config RestConfiguration configuration,
        @Connection RequesterConnection connection,
        CompletionCallback<InputStream, Object> completionCallback,
        String endpoint,
        @Content(primary = true)
        @TypeResolver(ValuesParameterHttpRequesterOperation.class)
        TypedValue<InputStream> values) {
        try {
            connection.sendAsync(HttpRequest.builder()
                                     .uri(connection.getBaseUri() + "/" + endpoint)
                                     .method(HttpConstants.Method.GET)
                                     .build(),
                                 resolveDefaultResponseMediaType(configuration))
                .thenAccept(result -> completionCallback.success(Result.<InputStream, Object>builder()
                                                                     .output(result.getEntityContent())
                                                                     .mediaType(result.getMediaType())
                                                                     .build()))
                .exceptionally(notifyCompletionCallbackError(completionCallback));
        } catch (Throwable t) {
            completionCallback.error(t);
        }
    }

}
