/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.schema.test;

import com.mulesoft.flatfile.schema.hl7.HL7Error;
import com.mulesoft.flatfile.schema.hl7.HL7Identity;
import com.mulesoft.flatfile.schema.hl7.HL7ParserConfig;
import com.mulesoft.flatfile.schema.hl7.HL7SchemaDefs$;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.tools.DecodeHL7ACK$;
import com.mulesoft.flatfile.schema.tools.DocumentTest$;
import com.mulesoft.flatfile.schema.tools.DocumentTestHL7;
import com.mulesoft.flatfile.schema.tools.DocumentTestHL7$;
import com.mulesoft.flatfile.schema.tools.YamlSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TestHL7Document {
    public static void main(String[] args2) {
        if (args2.length < 2) {
            throw new IllegalArgumentException("Missing required argument(s): schema-path file-path");
        }
        if (args2.length > 3) {
            throw new IllegalArgumentException("Too many argument(s): schema-path file-path [numpref]");
        }
        boolean numpref = args2.length == 3 && "numpref".equals(args2[2]);
        EdiSchema schema = DocumentTest$.MODULE$.loadSchema(args2[0], !numpref, false, null);
        Structure struct = DocumentTestHL7$.MODULE$.msg25ACK();
        Segment msh = HL7SchemaDefs$.MODULE$.mshSegment(struct);
        DocumentTestHL7 test = DocumentTestHL7$.MODULE$.apply(schema, (String)schema.structures().keySet().iterator().next(), new HL7ParserConfig(false, false, false, false, false, false, false, false, -1, Pattern.compile(""), struct, msh, new HL7Identity.HL7IdentityInformation[0], new HL7Identity.HL7IdentityInformation[0]));
        try {
            Map data2;
            Map ack;
            FileInputStream is = new FileInputStream(new File(args2[1]));
            Map<String, Object> result2 = test.parse(is);
            System.out.println();
            List errors = (List)result2.get("Errors");
            if (errors != null && errors.size() > 0) {
                System.out.println("Errors:");
                for (HL7Error error2 : errors) {
                    System.out.println(error2);
                }
                System.out.println();
            }
            if ((ack = (Map)result2.get("ACK")) != null) {
                System.out.println("Acknowledgment:");
                System.out.println(DecodeHL7ACK$.MODULE$.decode(ack, struct));
            }
            if ((data2 = (Map)result2.get("Data")) != null) {
                System.out.println("Message data:");
                StringWriter writer = new StringWriter();
                YamlSupport.writeMap(data2, writer);
                System.out.println(writer.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

