/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.NumberFormatBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class ImpliedDecimalFormat
extends NumberFormatBase {
    private final int decimalPosition;

    public ImpliedDecimalFormat(String code2, int min2, int max2, TypeFormatConstants.NumberSign sign2, boolean count2, TypeFormatConstants.FillMode mode, int pos) {
        super(code2, min2, max2, sign2, count2, mode, '0');
        this.decimalPosition = pos;
    }

    @Override
    public TypeFormatConstants.GenericType genericType() {
        return TypeFormatConstants.GenericType.REAL;
    }

    @Override
    public Object parse(LexerBase lexer) throws LexicalException {
        this.checkIntegerFormat(lexer, this.fillMode, this.fillChar);
        return new BigDecimal(new BigInteger(lexer.token()), this.decimalPosition);
    }

    private void writeDecimal(BigDecimal value2, WriterBase writer) throws IOException {
        BigDecimal decimal = value2;
        decimal = decimal.movePointRight(this.decimalPosition).setScale(this.decimalPosition, RoundingMode.HALF_UP);
        this.writeBigInteger(decimal.toBigIntegerExact(), writer);
    }

    @Override
    public void write(Object value2, WriterBase writer) throws IOException {
        writer.startToken();
        if (value2 instanceof BigDecimal) {
            this.writeDecimal((BigDecimal)value2, writer);
        } else if (value2 instanceof Integer) {
            this.writeDecimal(new BigDecimal((Integer)value2), writer);
        } else if (value2 instanceof Long) {
            this.writeDecimal(new BigDecimal((Long)value2), writer);
        } else if (value2 instanceof BigInteger) {
            this.writeDecimal(new BigDecimal((BigInteger)value2), writer);
        } else {
            this.wrongType(value2, writer);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ImpliedDecimalFormat && super.equals(obj)) {
            return this.decimalPosition == ((ImpliedDecimalFormat)obj).decimalPosition;
        }
        return false;
    }
}

