/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.IBM037;
import com.mulesoft.flatfile.lexical.LexicalDataException;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.WriterBase;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.log4j.Logger;
import scala.Char;

public class FlatFileWriter
extends WriterBase {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private static final char[] SPACES = "                                                                                               ".toCharArray();
    private static final char[] NULLS = new char[32];
    private final Charset encoding;
    private final String segmentSeparator;
    private final scala.collection.immutable.Map<Char, Char> zonedPositiveChars;
    private final scala.collection.immutable.Map<Char, Char> zonedNegativeChars;
    private Boolean supportsRaw;
    private char[] rawTransform;

    public FlatFileWriter(OutputStream os, Charset enc, String segsep, scala.collection.immutable.Map<Char, Char> zonePos, scala.collection.immutable.Map<Char, Char> zoneNeg) {
        super(new BufferedWriter(new OutputStreamWriter(os, enc)), '.');
        if ("IBM037".equals(enc.displayName())) {
            this.encoding = IBM037.charsetInstance;
            this.rawTransform = IBM037.charsetInstance.getReverseWriteTransform();
            this.supportsRaw = Boolean.TRUE;
        } else {
            this.encoding = enc;
        }
        this.segmentSeparator = segsep;
        this.zonedPositiveChars = zonePos;
        this.zonedNegativeChars = zoneNeg;
    }

    public Charset getCharset() {
        return this.encoding;
    }

    @Override
    public void init(Map<String, Object> props) {
    }

    @Override
    public void term(Map<String, Object> props) {
    }

    @Override
    public void writeToken(String text2) throws IOException {
        this.writer.write(text2);
    }

    @Override
    public void error(TypeFormat typ2, ErrorHandler.ErrorCondition err2, String text2) throws LexicalException {
        boolean abort = false;
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ2, err2, text2);
            }
            this.errorHandler.error(typ2, err2, text2);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                this.logger.error("Unrecoverable lexer error " + text2);
            } else {
                this.logger.info("Recoverable lexer error " + text2);
            }
        }
    }

    @Override
    public void startToken() throws IOException {
    }

    @Override
    public void writeUnchecked(char[] chars, int offset, int length) throws IOException {
        this.writer.write(chars, offset, length);
    }

    @Override
    public void writeUnchecked(String text2) throws IOException {
        this.writer.write(text2);
    }

    @Override
    public void writeEscaped(String text2) throws IOException {
        this.writer.write(text2);
    }

    public void writeRaw(byte[] bytes2) throws IOException {
        char[] chars;
        if (this.supportsRaw == null) {
            ByteBuffer bbuf = ByteBuffer.allocate(256);
            for (int i = 0; i < 256; ++i) {
                bbuf.put((byte)i);
            }
            bbuf.position(0);
            CharBuffer cbuf = this.encoding.decode(bbuf);
            byte[] rbytes = this.encoding.encode(cbuf).array();
            this.supportsRaw = Boolean.FALSE;
            if (rbytes.length == 256) {
                this.supportsRaw = Boolean.TRUE;
                for (int i = 0; i < 256; ++i) {
                    if ((rbytes[i] & 0xFF) == i) continue;
                    this.supportsRaw = Boolean.FALSE;
                    break;
                }
                this.rawTransform = cbuf.array();
            }
        }
        if (this.supportsRaw.booleanValue()) {
            chars = new char[bytes2.length];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.rawTransform[bytes2[i] & 0xFF];
            }
        } else {
            throw new IllegalStateException("Raw data is not supported for character encoding " + this.encoding.name());
        }
        this.writer.write(chars);
    }

    private void writeFill(int size2, char[] chrs) throws IOException {
        int rem;
        for (rem = size2; rem >= chrs.length; rem -= chrs.length) {
            this.writer.write(chrs);
        }
        if (rem > 0) {
            this.writer.write(chrs, 0, rem);
        }
    }

    public void writeBlank(int size2) throws IOException {
        this.writeFill(size2, SPACES);
    }

    public void writeNull(int size2) throws IOException {
        this.writeFill(size2, NULLS);
    }

    public void writeChar(int size2, char chr) throws IOException {
        if (chr == '\u0000') {
            this.writeNull(size2);
        } else if (chr == ' ') {
            this.writeBlank(size2);
        } else {
            for (int i = 0; i < size2; ++i) {
                this.writer.write(chr);
            }
        }
    }

    @Override
    public void writeSegmentTerminator() throws IOException {
        if (this.segmentSeparator != null) {
            this.writer.write(this.segmentSeparator);
        }
        ++this.segmentCount;
    }

    public scala.collection.immutable.Map<Char, Char> getZonedPositiveChars() {
        return this.zonedPositiveChars;
    }

    public scala.collection.immutable.Map<Char, Char> getZonedNegativeChars() {
        return this.zonedNegativeChars;
    }
}

