/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.x12;

import com.mulesoft.flatfile.lexical.DelimiterLexer;
import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.x12.X12Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;

public class X12Lexer
extends DelimiterLexer {
    public X12Lexer(InputStream is, Charset charset) {
        super(is, -1);
        this.reader = new BufferedReader(new InputStreamReader(this.stream, charset));
    }

    public void configure(int subst, X12Constants.CharacterRestriction chset) {
        this.substitutionChar = subst;
        this.allowedChars = chset.flags();
    }

    @Override
    protected void handleEscape(StringBuilder builder) {
        throw new RuntimeException("Not used for X12");
    }

    private static InterchangeStartStatus replaceValidStatus(InterchangeStartStatus status, InterchangeStartStatus replace) {
        if (status == InterchangeStartStatus.VALID) {
            return replace;
        }
        return status;
    }

    public InterchangeStartStatus init(Map<String, Object> props) {
        try {
            int value2 = this.reader.read();
            while (value2 == 10 || value2 == 13 || value2 == 32) {
                value2 = this.reader.read();
            }
            if (value2 < 0) {
                return InterchangeStartStatus.NO_DATA;
            }
            char[] chrs = new char[]{(char)value2, (char)this.reader.read(), (char)this.reader.read()};
            String tag = new String(chrs);
            if (!"ISA".equals(tag)) {
                throw new IllegalStateException("Message is missing ISA segment (starts with " + tag + ")");
            }
            this.dataSeparator = (char)this.reader.read();
            this.advance(EdiConstants.ItemType.DATA_ELEMENT);
            InterchangeStartStatus result2 = InterchangeStartStatus.VALID;
            try {
                props.put("ISA01", X12Constants.VALID2.parse(this));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.AUTHORIZATION_QUALIFIER_ERROR);
            }
            this.advance();
            try {
                props.put("ISA02", X12Constants.VALAN10.parse(this));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.AUTHORIZATION_INFO_ERROR);
            }
            this.advance();
            try {
                props.put("ISA03", X12Constants.VALID2.parse(this));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.SECURITY_QUALIFIER_ERROR);
            }
            this.advance();
            try {
                props.put("ISA04", X12Constants.VALAN10.parse(this));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.SECURITY_INFO_ERROR);
            }
            this.advance();
            try {
                props.put("ISA05", X12Constants.VALID2.parse(this));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.SENDER_ID_QUALIFIER_ERROR);
            }
            this.advance();
            try {
                props.put("ISA06", X12Constants.VALAN15.parse(this));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.SENDER_ID_ERROR);
            }
            this.advance();
            try {
                props.put("ISA07", X12Constants.VALID2.parse(this));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.RECEIVER_ID_QUALIFIER_ERROR);
            }
            this.advance();
            try {
                props.put("ISA08", X12Constants.VALAN15.parse(this));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.RECEIVER_ID_ERROR);
            }
            this.advance();
            try {
                props.put("ISA09", X12Constants.VALDT6.parse(this));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.INTERCHANGE_DATE_ERROR);
            }
            this.advance();
            try {
                props.put("ISA10", (int)((Integer)X12Constants.VALTM4.parse(this)));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.INTERCHANGE_TIME_ERROR);
            }
            this.advance();
            String sep = X12Constants.VALAN1.parse(this).toString();
            this.repetitionSeparator = "U".equals(sep) ? -1 : (int)sep.charAt(0);
            this.advance();
            try {
                props.put("ISA12", X12Constants.VALID5.parse(this));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.VERSION_ID_ERROR);
            }
            this.advance();
            try {
                props.put("ISA13", X12Constants.VALN9.parse(this));
            }
            catch (LexicalException e) {
                throw new LexicalException("Interchange aborted due to Interchange Control Number error", e);
            }
            this.advance();
            try {
                props.put("ISA14", X12Constants.VALID1.parse(this));
            }
            catch (LexicalException e) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.ACK_REQUESTED_ERROR);
            }
            this.advance();
            String indicator = X12Constants.VALAN1.parse(this).toString();
            if (indicator.length() != 1 || !"I".equals(indicator) && !"P".equals(indicator) && !"T".equals(indicator)) {
                result2 = X12Lexer.replaceValidStatus(result2, InterchangeStartStatus.TEST_INDICATOR_ERROR);
            }
            props.put("ISA15", indicator);
            this.componentSeparator = (char)this.reader.read();
            this.segmentTerminator = (char)this.reader.read();
            this.groupCount = 0;
            this.advance(EdiConstants.ItemType.SEGMENT);
            return result2;
        }
        catch (IOException e) {
            throw new IllegalStateException("Interchange aborted due to error reading header", e);
        }
    }

    public InterchangeEndStatus term(Map<String, Object> props) throws IOException {
        if (!"IEA".equals(this.segmentTag())) {
            throw new IllegalStateException("not at trailer");
        }
        this.advance();
        int count2 = (Integer)X12Constants.VALN1_5.parse(this);
        if (count2 != this.groupCount) {
            return InterchangeEndStatus.GROUP_COUNT_ERROR;
        }
        this.advance();
        int number2 = (Integer)X12Constants.VALN9.parse(this);
        Object expected = props.get("ISA13");
        if (!(expected instanceof Integer)) {
            throw new IllegalStateException("ISA13 value must be an Integer");
        }
        if ((Integer)expected != number2) {
            return InterchangeEndStatus.CONTROL_NUMBER_ERROR;
        }
        return InterchangeEndStatus.VALID;
    }

    public static enum InterchangeEndStatus {
        VALID,
        GROUP_COUNT_ERROR,
        CONTROL_NUMBER_ERROR;

    }

    public static enum InterchangeStartStatus {
        VALID,
        AUTHORIZATION_QUALIFIER_ERROR,
        AUTHORIZATION_INFO_ERROR,
        SECURITY_QUALIFIER_ERROR,
        SECURITY_INFO_ERROR,
        SENDER_ID_QUALIFIER_ERROR,
        SENDER_ID_ERROR,
        RECEIVER_ID_QUALIFIER_ERROR,
        RECEIVER_ID_ERROR,
        INTERCHANGE_DATE_ERROR,
        INTERCHANGE_TIME_ERROR,
        VERSION_ID_ERROR,
        INTER_CONTROL_ERROR,
        ACK_REQUESTED_ERROR,
        TEST_INDICATOR_ERROR,
        NO_DATA;

    }
}

