/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.DelimiterLexer;
import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.LexicalException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;

public class HL7Lexer
extends DelimiterLexer {
    public HL7Lexer(InputStream is, int subst) {
        super(is, -1);
        this.substitutionChar = subst;
        this.segmentTerminator = (char)13;
    }

    @Override
    protected void handleEscape(StringBuilder builder) throws IOException {
        block15: {
            char rls;
            StringBuilder escaped2;
            int code;
            block14: {
                int value2;
                code = this.reader.read();
                if (code < 0) {
                    throw new LexicalException("end of input in escape sequence");
                }
                escaped2 = new StringBuilder();
                while ((value2 = this.reader.read()) >= 0 && value2 != this.releaseIndicator) {
                    escaped2.append((char)value2);
                }
                if (value2 < 0) {
                    throw new LexicalException("malformed escape sequence in input");
                }
                rls = (char)this.releaseIndicator;
                if (escaped2.length() != 0) break block14;
                switch (code) {
                    case 69: {
                        builder.append(rls);
                        break block15;
                    }
                    case 70: {
                        builder.append(this.dataSeparator);
                        break block15;
                    }
                    case 82: {
                        builder.append((char)this.repetitionSeparator);
                        break block15;
                    }
                    case 83: {
                        builder.append(this.componentSeparator);
                        break block15;
                    }
                    case 84: {
                        builder.append((char)this.subCompSeparator);
                        break block15;
                    }
                    case 72: 
                    case 78: {
                        builder.append(rls);
                        builder.append((char)code);
                        builder.append(rls);
                        break block15;
                    }
                    default: {
                        throw new LexicalException("unsupported escape sequence code '" + (char)code + '\'');
                    }
                }
            }
            switch (code) {
                case 46: 
                case 88: 
                case 90: {
                    builder.append(rls);
                    builder.append((char)code);
                    builder.append((CharSequence)escaped2);
                    builder.append(rls);
                    break;
                }
                default: {
                    throw new LexicalException("unsupported escape sequence code '" + (char)code + '\'');
                }
            }
        }
    }

    public void setEncoding(Charset charSet) {
        this.reader = new InputStreamReader(this.stream, charSet);
    }

    public String init(Map<String, Object> props) throws LexicalException {
        try {
            byte[] byts = this.readBytes(3);
            String tag = new String(byts, EdiConstants.ASCII_CHARSET);
            if (!"MSH".equals(tag)) {
                throw new RuntimeException("Message does not start with 'MSH'");
            }
            byts = this.readBytes(5);
            this.dataSeparator = (char)byts[0];
            this.componentSeparator = (char)byts[1];
            this.repetitionSeparator = (char)byts[2];
            this.releaseIndicator = (char)byts[3];
            this.subCompSeparator = (char)byts[4];
            if (this.stream.read() != this.dataSeparator) {
                throw new RuntimeException("Field separator not present following MSH-01");
            }
            this.segmentTag = "MSH";
            this.reader = new ByteReader();
            this.advance(EdiConstants.ItemType.DATA_ELEMENT);
            this.elementNumber = 2;
            return new String(byts, EdiConstants.ASCII_CHARSET);
        }
        catch (IOException e) {
            throw new LexicalException("Message aborted due to error reading header", e);
        }
    }

    public void term(Map<String, Object> props) throws IOException {
    }

    private class ByteReader
    extends Reader {
        private ByteReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int chr;
            int actual = -1;
            while (actual < len - 1 && (chr = HL7Lexer.this.stream.read()) >= 0) {
                cbuf[off + ++actual] = (char)chr;
            }
            return actual;
        }

        @Override
        public void close() throws IOException {
            HL7Lexer.this.stream.close();
        }
    }

    public static enum InterchangeEndStatus {
        VALID,
        GROUP_COUNT_ERROR,
        CONTROL_NUMBER_ERROR;

    }
}

