/*
 * Decompiled with CFR 0.152.
 */
package spire.math.algebraic;

import scala.math.BigDecimal;
import scala.math.BigInt;
import spire.math.Rational;
import spire.math.algebraic.MaybeDouble;
import spire.math.package$;

public final class MaybeDouble$ {
    public static final MaybeDouble$ MODULE$;
    private final double eps;
    private final float feps;
    private final double maxWhole;
    private final double minWhole;
    private final MaybeDouble Invalid;

    static {
        new MaybeDouble$();
    }

    public double eps() {
        return this.eps;
    }

    public float feps() {
        return this.feps;
    }

    public double maxWhole() {
        return this.maxWhole;
    }

    public double minWhole() {
        return this.minWhole;
    }

    public MaybeDouble Invalid() {
        return this.Invalid;
    }

    public MaybeDouble apply(float x) {
        return this.exact(x);
    }

    public MaybeDouble apply(double x) {
        return this.exact(x);
    }

    public MaybeDouble apply(int x) {
        return this.exact(x);
    }

    public MaybeDouble apply(long x) {
        return (double)x >= this.minWhole() && (double)x <= this.maxWhole() ? this.exact(x) : this.approx(x);
    }

    public MaybeDouble apply(BigInt x) {
        double y = x.toDouble();
        return y >= this.minWhole() && y <= this.maxWhole() ? this.exact(y) : this.approx(y);
    }

    public MaybeDouble apply(Rational x) {
        return this.approx(x.toDouble());
    }

    public MaybeDouble apply(BigDecimal x) {
        return this.approx(x.toDouble());
    }

    public MaybeDouble exact(double x) {
        return new MaybeDouble(x, package$.MODULE$.abs(x), 0);
    }

    public MaybeDouble approx(double x) {
        return new MaybeDouble(x, package$.MODULE$.abs(x), 1);
    }

    private MaybeDouble$() {
        MODULE$ = this;
        this.eps = Double.longBitsToDouble(4372995238176751616L);
        this.feps = Float.intBitsToFloat(0x34000000);
        this.maxWhole = Double.longBitsToDouble(0x433FFFFFFFFFFFFFL);
        this.minWhole = -this.maxWhole();
        this.Invalid = new MaybeDouble(Double.NaN, 0.0, 0);
    }
}

