/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import spire.math.FastComplex$;
import spire.math.FloatComplex;

public final class FloatComplex$ {
    public static final FloatComplex$ MODULE$;
    private final long i;
    private final long one;
    private final long zero;

    static {
        new FloatComplex$();
    }

    public final long apply(float real, float imag) {
        FastComplex$ fastComplex$ = FastComplex$.MODULE$;
        return (long)Float.floatToRawIntBits(real) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(imag) & 0xFFFFFFFFL) << 32;
    }

    public final long apply(double real, double imag) {
        float f2 = (float)imag;
        float f3 = (float)real;
        FastComplex$ fastComplex$ = FastComplex$.MODULE$;
        return (long)Float.floatToRawIntBits(f3) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(f2) & 0xFFFFFFFFL) << 32;
    }

    public long polar(float magnitude, float angle) {
        FastComplex$ fastComplex$ = FastComplex$.MODULE$;
        float f2 = magnitude * (float)Math.sin(angle);
        return (long)Float.floatToRawIntBits(magnitude * (float)Math.cos(angle)) & 0xFFFFFFFFL | ((long)Float.floatToRawIntBits(f2) & 0xFFFFFFFFL) << 32;
    }

    public final long i() {
        return this.i;
    }

    public final long one() {
        return this.one;
    }

    public final long zero() {
        return this.zero;
    }

    public final String toString$extension(long $this) {
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps("(%s+%si)").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToFloat(this.real$extension($this)), BoxesRunTime.boxToFloat(this.imag$extension($this))}));
    }

    public final float real$extension(long $this) {
        int n = (int)($this & 0xFFFFFFFFFFFFFFFFL);
        FastComplex$ fastComplex$ = FastComplex$.MODULE$;
        return Float.intBitsToFloat(n);
    }

    public final float imag$extension(long $this) {
        int n = (int)($this >>> 32);
        FastComplex$ fastComplex$ = FastComplex$.MODULE$;
        return Float.intBitsToFloat(n);
    }

    public final String repr$extension(long $this) {
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps("FloatComplex(%s, %s)").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToFloat(this.real$extension($this)), BoxesRunTime.boxToFloat(this.imag$extension($this))}));
    }

    public final float abs$extension(long $this) {
        return FastComplex$.MODULE$.abs($this);
    }

    public final float angle$extension(long $this) {
        return FastComplex$.MODULE$.angle($this);
    }

    public final long conjugate$extension(long $this) {
        return FastComplex$.MODULE$.conjugate($this);
    }

    public final boolean isWhole$extension(long $this) {
        return FastComplex$.MODULE$.isWhole($this);
    }

    public final int signum$extension(long $this) {
        return FastComplex$.MODULE$.signum($this);
    }

    public final long complexSignum$extension(long $this) {
        return FastComplex$.MODULE$.complexSignum($this);
    }

    public final long negate$extension(long $this) {
        return FastComplex$.MODULE$.negate($this);
    }

    public final long $plus$extension(long $this, long b) {
        return FastComplex$.MODULE$.add($this, b);
    }

    public final long $minus$extension(long $this, long b) {
        return FastComplex$.MODULE$.subtract($this, b);
    }

    public final long $times$extension(long $this, long b) {
        return FastComplex$.MODULE$.multiply($this, b);
    }

    public final long $div$extension(long $this, long b) {
        return FastComplex$.MODULE$.divide($this, b);
    }

    public final long $div$tilde$extension(long $this, long b) {
        return FastComplex$.MODULE$.quot($this, b);
    }

    public final long $percent$extension(long $this, long b) {
        return FastComplex$.MODULE$.mod($this, b);
    }

    public final Tuple2<FloatComplex, FloatComplex> $div$percent$extension(long $this, long b) {
        Tuple2<Object, Object> tuple22 = FastComplex$.MODULE$.quotmod($this, b);
        if (tuple22 != null) {
            return new Tuple2<FloatComplex, FloatComplex>(new FloatComplex(tuple22._1$mcJ$sp()), new FloatComplex(tuple22._2$mcJ$sp()));
        }
        throw new MatchError(tuple22);
    }

    public final long pow$extension0(long $this, long b) {
        return FastComplex$.MODULE$.pow($this, b);
    }

    public final long $times$times$extension0(long $this, long b) {
        return this.pow$extension0($this, b);
    }

    public final long pow$extension1(long $this, int b) {
        return FastComplex$.MODULE$.pow($this, FastComplex$.MODULE$.apply(b, 0.0f));
    }

    public final long $times$times$extension1(long $this, int b) {
        return this.pow$extension1($this, b);
    }

    public final int hashCode$extension(long $this) {
        return ((Object)BoxesRunTime.boxToLong($this)).hashCode();
    }

    public final boolean equals$extension(long $this, Object x$1) {
        long l;
        boolean bl = x$1 instanceof FloatComplex;
        return bl && $this == (l = ((FloatComplex)x$1).u());
    }

    private FloatComplex$() {
        MODULE$ = this;
        this.i = 4575657221408423936L;
        this.one = 1065353216L;
        this.zero = 0L;
    }
}

