/*
 * Decompiled with CFR 0.152.
 */
package spire.math.prime;

import java.math.BigInteger;
import java.util.Random;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.Map$;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import spire.algebra.Sign;
import spire.algebra.Sign$;
import spire.algebra.Sign$Positive$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.prime.Factors;
import spire.math.prime.Factors$;
import spire.math.prime.Siever;
import spire.math.prime.package$;

public final class package$ {
    public static final package$ MODULE$;
    private final Random srand;
    private final int SieveSize;

    static {
        new package$();
    }

    public boolean isPrime(SafeLong n) {
        return n.isProbablePrime(40);
    }

    public Factors factor(SafeLong n) {
        return this.factorPollardRho(n);
    }

    public Factors factorTrialDivision(SafeLong n0) {
        Integer n = BoxesRunTime.boxToInteger(0);
        boolean bl = n0 != n ? (n0 != null ? (!(n0 instanceof Number) ? (!(n0 instanceof Character) ? n0.equals(n) : BoxesRunTime.equalsCharObject((Character)((Object)n0), n)) : BoxesRunTime.equalsNumObject(n0, n)) : false) : true;
        if (bl) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n2 = n0.abs();
        Sign sign2 = Sign$.MODULE$.apply(n0.signum());
        SafeLong safeLong = SafeLong$.MODULE$.one();
        boolean bl2 = n2 != safeLong ? (n2 != null ? (!(n2 instanceof Number) ? (!(n2 instanceof Character) ? n2.equals(safeLong) : BoxesRunTime.equalsCharObject((Character)((Object)n2), safeLong)) : BoxesRunTime.equalsNumObject(n2, safeLong)) : false) : true;
        if (bl2) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign2);
        }
        GenMap facts = Map$.MODULE$.empty();
        SafeLong x = n2;
        Tuple2<SafeLong, Object> tuple22 = this.findPowers(n2, SafeLong$.MODULE$.apply(2L));
        if (tuple22 != null) {
            Tuple2<SafeLong, Integer> tuple23 = new Tuple2<SafeLong, Integer>(tuple22._1(), BoxesRunTime.boxToInteger(tuple22._2$mcI$sp()));
            SafeLong x1 = tuple23._1();
            int e1 = tuple23._2$mcI$sp();
            if (e1 > 0) {
                facts.update(SafeLong$.MODULE$.apply(2L), BoxesRunTime.boxToInteger(e1));
                x = x1;
            }
            SafeLong limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x);
            SafeLong index$macro$543 = SafeLong$.MODULE$.apply(3L);
            while (index$macro$543.$less$eq(limit) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple24 = this.findPowers(x, index$macro$543);
                if (tuple24 != null) {
                    Tuple2<SafeLong, Integer> tuple25 = new Tuple2<SafeLong, Integer>(tuple24._1(), BoxesRunTime.boxToInteger(tuple24._2$mcI$sp()));
                    SafeLong x2 = tuple25._1();
                    int e2 = tuple25._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update(index$macro$543, BoxesRunTime.boxToInteger(e2));
                        x = x2;
                        limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x2);
                    }
                    index$macro$543 = index$macro$543.$plus(2L);
                    continue;
                }
                throw new MatchError(tuple24);
            }
            if (x.$greater(SafeLong$.MODULE$.apply(1L))) {
                facts.update(x, BoxesRunTime.boxToInteger(1));
            }
            return new Factors(facts.toMap(Predef$.MODULE$.$conforms()), sign2);
        }
        throw new MatchError(tuple22);
    }

    public Factors factorWheelDivision(SafeLong n0) {
        Integer n = BoxesRunTime.boxToInteger(0);
        boolean bl = n0 != n ? (n0 != null ? (!(n0 instanceof Number) ? (!(n0 instanceof Character) ? n0.equals(n) : BoxesRunTime.equalsCharObject((Character)((Object)n0), n)) : BoxesRunTime.equalsNumObject(n0, n)) : false) : true;
        if (bl) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n2 = n0.abs();
        Sign sign2 = Sign$.MODULE$.apply(n0.signum());
        Integer n3 = BoxesRunTime.boxToInteger(1);
        boolean bl2 = n2 != n3 ? (n2 != null ? (!(n2 instanceof Number) ? (!(n2 instanceof Character) ? n2.equals(n3) : BoxesRunTime.equalsCharObject((Character)((Object)n2), n3)) : BoxesRunTime.equalsNumObject(n2, n3)) : false) : true;
        if (bl2) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign2);
        }
        GenMap facts = Map$.MODULE$.empty();
        SafeLong x = n2;
        Tuple2<SafeLong, Object> tuple22 = this.findPowers(n2, SafeLong$.MODULE$.apply(2L));
        if (tuple22 != null) {
            Tuple2<SafeLong, Integer> tuple23 = new Tuple2<SafeLong, Integer>(tuple22._1(), BoxesRunTime.boxToInteger(tuple22._2$mcI$sp()));
            SafeLong x1 = tuple23._1();
            int e1 = tuple23._2$mcI$sp();
            if (e1 > 0) {
                facts.update(SafeLong$.MODULE$.apply(2L), BoxesRunTime.boxToInteger(e1));
                x = x1;
            }
            SafeLong index$macro$544 = SafeLong$.MODULE$.apply(3L);
            while (index$macro$544.$less(SafeLong$.MODULE$.apply(30L)) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple24 = this.findPowers(x, index$macro$544);
                if (tuple24 != null) {
                    Tuple2<SafeLong, Integer> tuple25 = new Tuple2<SafeLong, Integer>(tuple24._1(), BoxesRunTime.boxToInteger(tuple24._2$mcI$sp()));
                    SafeLong x2 = tuple25._1();
                    int e2 = tuple25._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update(index$macro$544, BoxesRunTime.boxToInteger(e2));
                        x = x2;
                    }
                    index$macro$544 = index$macro$544.$plus(2L);
                    continue;
                }
                throw new MatchError(tuple24);
            }
            SafeLong limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x);
            SafeLong b = SafeLong$.MODULE$.apply(31L);
            int i = 0;
            int[] offsets = new int[]{2, 2, 2, 4, 2, 4, 2, 4, 6, 2};
            while (b.$less$eq(limit) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple26 = this.findPowers(x, b);
                if (tuple26 != null) {
                    Tuple2<SafeLong, Integer> tuple27 = new Tuple2<SafeLong, Integer>(tuple26._1(), BoxesRunTime.boxToInteger(tuple26._2$mcI$sp()));
                    SafeLong x2 = tuple27._1();
                    int e2 = tuple27._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update(b, BoxesRunTime.boxToInteger(e2));
                        x = x2;
                        limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x2);
                    }
                    b = b.$plus(offsets[i]);
                    i = (i + 1) % 10;
                    continue;
                }
                throw new MatchError(tuple26);
            }
            if (x.$greater(SafeLong$.MODULE$.apply(1L))) {
                facts.update(x, BoxesRunTime.boxToInteger(1));
            }
            return new Factors(facts.toMap(Predef$.MODULE$.$conforms()), sign2);
        }
        throw new MatchError(tuple22);
    }

    public Factors factorPollardRho(SafeLong n0) {
        Integer n;
        Integer n2 = BoxesRunTime.boxToInteger(0);
        boolean bl = n0 != n2 ? (n0 != null ? (!(n0 instanceof Number) ? (!(n0 instanceof Character) ? n0.equals(n2) : BoxesRunTime.equalsCharObject((Character)((Object)n0), n2)) : BoxesRunTime.equalsNumObject(n0, n2)) : false) : true;
        if (bl) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n3 = n0.abs();
        boolean bl2 = n3 != (n = BoxesRunTime.boxToInteger(1)) ? (n3 != null ? (!(n3 instanceof Number) ? (!(n3 instanceof Character) ? n3.equals(n) : BoxesRunTime.equalsCharObject((Character)((Object)n3), n)) : BoxesRunTime.equalsNumObject(n3, n)) : false) : true;
        if (bl2) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), Sign$.MODULE$.apply(n0.signum()));
        }
        return n0.$less(SafeLong$.MODULE$.apply(0L)) ? this.factor$1(n3).unary_$minus() : this.factor$1(n3);
    }

    private Random srand() {
        return this.srand;
    }

    private SafeLong rand(SafeLong n) {
        int bits2 = n.bitLength();
        BigInteger x = new BigInteger(bits2, this.srand());
        while (x.signum() == 0) {
            x = new BigInteger(bits2, this.srand());
        }
        return SafeLong$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(x));
    }

    private Tuple2<SafeLong, Object> findPowers(SafeLong x0, SafeLong b) {
        SafeLong x = x0;
        int e = 0;
        while (x.$greater(SafeLong$.MODULE$.apply(1L))) {
            Integer n = BoxesRunTime.boxToInteger(0);
            SafeLong safeLong = x.$percent(b);
            boolean bl = safeLong != n ? (safeLong != null ? (!(safeLong instanceof Number) ? (!(safeLong instanceof Character) ? safeLong.equals(n) : BoxesRunTime.equalsCharObject((Character)((Object)safeLong), n)) : BoxesRunTime.equalsNumObject(safeLong, n)) : false) : true;
            if (!bl) break;
            ++e;
            x = x.$div(b);
        }
        return new Tuple2<SafeLong, Object>(x, BoxesRunTime.boxToInteger(e));
    }

    private int SieveSize() {
        return this.SieveSize;
    }

    public Siever sieverUpToNth(long n) {
        double upper = (double)n * spire.math.package$.MODULE$.log(n) + (double)n * spire.math.package$.MODULE$.log(spire.math.package$.MODULE$.log((double)n - 0.9385));
        long cutoff = spire.math.package$.MODULE$.max(1000L, (long)(spire.math.package$.MODULE$.sqrt(upper) + (double)512L));
        return new Siever(this.SieveSize(), SafeLong$.MODULE$.apply(cutoff));
    }

    public SafeLong nth(long n) {
        return this.sieverUpToNth(n).nth(n);
    }

    /*
     * WARNING - void declaration
     */
    public SafeLong[] fill(int n) {
        SafeLong[] safeLongArray;
        if (n <= 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger(n)).toString());
        }
        if (n == 1) {
            safeLongArray = (SafeLong[])((Object[])new SafeLong[]{SafeLong$.MODULE$.two()});
        } else {
            void var3_3;
            Siever siever = this.sieverUpToNth(n);
            SafeLong[] arr = new SafeLong[n];
            arr[0] = SafeLong$.MODULE$.two();
            arr[1] = SafeLong$.MODULE$.three();
            this.loop$1(2, SafeLong$.MODULE$.three(), siever, arr);
            safeLongArray = var3_3;
        }
        return safeLongArray;
    }

    public SafeLong[] fill(int start, int limit) {
        SafeLong[] safeLongArray;
        if (start == 0) {
            safeLongArray = this.fill(limit);
        } else {
            Siever siever = this.sieverUpToNth(start + limit);
            safeLongArray = this.loop$2(1, SafeLong$.MODULE$.three(), start, limit, siever);
        }
        return safeLongArray;
    }

    public Stream<SafeLong> stream() {
        return this.stream(this.SieveSize(), SafeLong$.MODULE$.apply(1000000L));
    }

    public Stream<SafeLong> stream(int chunkSize, SafeLong cutoff) {
        SafeLong safeLong = SafeLong$.MODULE$.two();
        return Stream$.MODULE$.consWrapper(new Serializable(chunkSize, cutoff){
            public static final long serialVersionUID = 0L;
            public final int chunkSize$1;
            public final SafeLong cutoff$1;

            public final Stream<SafeLong> apply() {
                SafeLong safeLong = SafeLong$.MODULE$.three();
                return Stream$.MODULE$.consWrapper(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.stream.1 $outer;

                    public final Stream<SafeLong> apply() {
                        return new Siever(this.$outer.chunkSize$1, this.$outer.cutoff$1).streamAfter(SafeLong$.MODULE$.three());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).$hash$colon$colon(safeLong);
            }
            {
                this.chunkSize$1 = chunkSize$1;
                this.cutoff$1 = cutoff$1;
            }
        }).$hash$colon$colon(safeLong);
    }

    private final SafeLong f$1(SafeLong x, SafeLong n$1, SafeLong c$1) {
        return x.$times(x).$percent(n$1).$plus(c$1).$percent(n$1);
    }

    private final SafeLong fastRho$1(SafeLong x, SafeLong q0, SafeLong r, SafeLong m, SafeLong n$1, SafeLong c$1) {
        SafeLong ys;
        SafeLong g;
        while (true) {
            Integer n;
            SafeLong y = x;
            SafeLong q = q0;
            int index$macro$545 = 0;
            while (r.$greater(SafeLong$.MODULE$.apply(index$macro$545))) {
                y = y.$times(y).$percent(n$1).$plus(c$1).$percent(n$1);
                ++index$macro$545;
            }
            g = SafeLong$.MODULE$.one();
            SafeLong k = SafeLong$.MODULE$.zero();
            ys = y;
            while (r.$greater(k)) {
                Integer n2 = BoxesRunTime.boxToInteger(1);
                boolean bl = g != n2 ? (g != null ? (!(g instanceof Number) ? (!(g instanceof Character) ? g.equals(n2) : BoxesRunTime.equalsCharObject((Character)((Object)g), n2)) : BoxesRunTime.equalsNumObject(g, n2)) : false) : true;
                if (!bl) break;
                ys = y;
                SafeLong limit = m.min(r.$minus(k));
                int index$macro$546 = 0;
                while (limit.$greater(SafeLong$.MODULE$.apply(index$macro$546))) {
                    y = y.$times(y).$percent(n$1).$plus(c$1).$percent(n$1);
                    q = q.$times(x.$minus(y).abs()).$percent(n$1);
                    ++index$macro$546;
                }
                Integer n3 = BoxesRunTime.boxToInteger(0);
                g = (q != n3 ? (q != null ? (!(q instanceof Number) ? (!(q instanceof Character) ? q.equals(n3) : BoxesRunTime.equalsCharObject((Character)((Object)q), n3)) : BoxesRunTime.equalsNumObject(q, n3)) : false) : true) ? n$1 : n$1.gcd(q);
                k = k.$plus(m);
            }
            boolean bl = g != (n = BoxesRunTime.boxToInteger(1)) ? (g != null ? (!(g instanceof Number) ? (!(g instanceof Character) ? g.equals(n) : BoxesRunTime.equalsCharObject((Character)((Object)g), n)) : BoxesRunTime.equalsNumObject(g, n)) : false) : true;
            if (!bl) break;
            r = r.$times(2L);
            q0 = q;
            x = y;
        }
        return (g != n$1 ? (g != null ? (!(g instanceof Number) ? (!(g instanceof Character) ? g.equals(n$1) : BoxesRunTime.equalsCharObject((Character)((Object)g), n$1)) : BoxesRunTime.equalsNumObject(g, n$1)) : false) : true) ? this.slowRho$1(x, ys, n$1, c$1) : g;
    }

    private final SafeLong slowRho$1(SafeLong x, SafeLong ys, SafeLong n$1, SafeLong c$1) {
        SafeLong g;
        while (true) {
            Integer n;
            SafeLong yys;
            boolean bl = (g = n$1.gcd(x.$minus(yys = ys.$times(ys).$percent(n$1).$plus(c$1).$percent(n$1)).abs())) != (n = BoxesRunTime.boxToInteger(1)) ? (g != null ? (!(g instanceof Number) ? (!(g instanceof Character) ? g.equals(n) : BoxesRunTime.equalsCharObject((Character)((Object)g), n)) : BoxesRunTime.equalsNumObject(g, n)) : false) : true;
            if (!bl) break;
            ys = yys;
        }
        return g;
    }

    private final SafeLong rho$1(SafeLong n, SafeLong c) {
        return this.fastRho$1(this.rand(n), SafeLong$.MODULE$.one(), SafeLong$.MODULE$.one(), this.rand(n), n, c);
    }

    private final Factors factor$1(SafeLong n) {
        Factors factors;
        Integer n2 = BoxesRunTime.boxToInteger(1);
        boolean bl = n != n2 ? (n != null ? (!(n instanceof Number) ? (!(n instanceof Character) ? n.equals(n2) : BoxesRunTime.equalsCharObject((Character)((Object)n), n2)) : BoxesRunTime.equalsNumObject(n, n2)) : false) : true;
        if (bl) {
            factors = Factors$.MODULE$.one();
        } else if (this.isPrime(n)) {
            factors = new Factors((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<SafeLong, Integer>(n, BoxesRunTime.boxToInteger(1))})), Sign$Positive$.MODULE$);
        } else if (n.isEven()) {
            SafeLong x = n.$div(2L);
            int e = 1;
            while (x.isEven()) {
                x = x.$div(2L);
                ++e;
            }
            factors = new Factors((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<SafeLong, Integer>(SafeLong$.MODULE$.apply(2L), BoxesRunTime.boxToInteger(e))})), Sign$Positive$.MODULE$).$times(this.factor$1(x));
        } else {
            SafeLong divisor = this.rho$1(n, this.rand(n));
            while (true) {
                boolean bl2 = divisor != n ? (divisor != null ? (!(divisor instanceof Number) ? (!(divisor instanceof Character) ? divisor.equals(n) : BoxesRunTime.equalsCharObject((Character)((Object)divisor), n)) : BoxesRunTime.equalsNumObject(divisor, n)) : false) : true;
                if (!bl2) break;
                divisor = this.rho$1(n, this.rand(n));
            }
            factors = this.factor$1(divisor).$times(this.factor$1(n.$div(divisor)));
        }
        return factors;
    }

    private final void loop$1(int i, SafeLong last2, Siever siever$1, SafeLong[] arr$1) {
        while (i < arr$1.length) {
            SafeLong p;
            arr$1[i] = p = siever$1.nextAfter(last2);
            last2 = p;
            ++i;
        }
    }

    private final SafeLong[] loop$2(int i, SafeLong p, int start$1, int limit$1, Siever siever$2) {
        while (i < start$1) {
            p = siever$2.nextAfter(p);
            ++i;
        }
        return siever$2.arrayAt(p, limit$1);
    }

    private package$() {
        MODULE$ = this;
        this.srand = new Random();
        this.SieveSize = 9600000;
    }
}

