/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive
public class AppenderControlArraySet {
    private final AtomicReference<AppenderControl[]> appenderArray = new AtomicReference<AppenderControl[]>(new AppenderControl[0]);

    public boolean add(AppenderControl control) {
        AppenderControl[] copy2;
        AppenderControl[] original;
        boolean success2;
        do {
            for (AppenderControl existing : original = this.appenderArray.get()) {
                if (!existing.equals(control)) continue;
                return false;
            }
            copy2 = Arrays.copyOf(original, original.length + 1);
            copy2[copy2.length - 1] = control;
        } while (!(success2 = this.appenderArray.compareAndSet(original, copy2)));
        return true;
    }

    public AppenderControl remove(String name) {
        boolean success2;
        block0: do {
            success2 = true;
            AppenderControl[] original = this.appenderArray.get();
            for (int i = 0; i < original.length; ++i) {
                AppenderControl appenderControl = original[i];
                if (!Objects.equals(name, appenderControl.getAppenderName())) continue;
                AppenderControl[] copy2 = this.removeElementAt(i, original);
                if (this.appenderArray.compareAndSet(original, copy2)) {
                    return appenderControl;
                }
                success2 = false;
                continue block0;
            }
        } while (!success2);
        return null;
    }

    private AppenderControl[] removeElementAt(int i, AppenderControl[] array) {
        AppenderControl[] result2 = Arrays.copyOf(array, array.length - 1);
        System.arraycopy(array, i + 1, result2, i, result2.length - i);
        return result2;
    }

    public Map<String, Appender> asMap() {
        HashMap<String, Appender> result2 = new HashMap<String, Appender>();
        for (AppenderControl appenderControl : this.appenderArray.get()) {
            result2.put(appenderControl.getAppenderName(), appenderControl.getAppender());
        }
        return result2;
    }

    public AppenderControl[] clear() {
        return this.appenderArray.getAndSet(new AppenderControl[0]);
    }

    public boolean isEmpty() {
        return this.appenderArray.get().length == 0;
    }

    public AppenderControl[] get() {
        return this.appenderArray.get();
    }
}

