/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.schema.test;

import com.mulesoft.flatfile.schema.SchemaJavaValues;
import com.mulesoft.flatfile.schema.edifact.EdifactSchemaDefs;
import com.mulesoft.flatfile.schema.model.DelimitedCompositeComponent;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.tools.DecodeContrl;
import com.mulesoft.flatfile.schema.tools.DocumentTest;
import com.mulesoft.flatfile.schema.tools.DocumentTest$;
import com.mulesoft.flatfile.schema.tools.DocumentTestEdifact;
import com.mulesoft.flatfile.schema.tools.YamlSupport;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestEdifactDocument {
    private static final String CHARSET = "ISO8859-1";

    private static void printAcknowledgments(Map<String, Object> result2) {
        List acks = (List)result2.get(SchemaJavaValues.functionalAcksGenerated());
        if (acks != null) {
            String key = ((DelimitedCompositeComponent)EdifactSchemaDefs.segUNBv4().components().head()).composite().components().apply(1).key();
            for (Map ack : acks) {
                ((Map)ack.get(SchemaJavaValues.interchangeKey())).put(key, "4");
                System.out.println(DecodeContrl.decode(ack));
            }
        }
    }

    private static void checkWrite(DocumentTest test, String text, Map<String, Object> result2) {
        String input = DocumentTest$.MODULE$.stripLineBreaks(text);
        String outtext = test.printDoc(result2);
        String output = DocumentTest$.MODULE$.stripLineBreaks(outtext);
        System.out.println("\nOutput comparison:");
        if (output.length() != input.length()) {
            System.out.println("Different lengths (" + output.length() + " vs " + input.length() + ")");
        }
        int length = Math.min(input.length(), output.length());
        int index = -1;
        while (++index < length && input.charAt(index) == output.charAt(index)) {
        }
        if (index < length) {
            System.out.println("Different text starting at " + index);
            int base = Math.max(index - 40, 0);
            int limit = Math.min(index + 40, length);
            System.out.println("output '" + output.substring(base, limit) + "'");
            System.out.println("input  '" + input.substring(base, limit) + "'");
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            throw new IllegalArgumentException("Missing required argument(s): schema-path file-path [print/noprint]");
        }
        if (args.length > 3) {
            throw new IllegalArgumentException("Too many argument(s): schema-path file-path [print/noprint]");
        }
        boolean print = args.length > 2 && "print".equals(args[2]);
        EdiSchema schema = DocumentTest$.MODULE$.loadSchema(args[0]);
        DocumentTestEdifact test = new DocumentTestEdifact(schema);
        try {
            String input = DocumentTest$.MODULE$.readAsString(args[1]);
            ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(CHARSET));
            Map<String, Object> result2 = ((DocumentTest)test).parse(is);
            System.out.println("\nFunctional acknowledgement(s):");
            TestEdifactDocument.printAcknowledgments(result2);
            ((DocumentTest)test).prepareOutput(result2);
            if (!result2.containsKey(SchemaJavaValues.delimiterCharacters())) {
                result2.put(SchemaJavaValues.delimiterCharacters(), "+:*'?");
            }
            HashMap<String, Object> copy = new HashMap<String, Object>(result2);
            String delims = (String)copy.get(SchemaJavaValues.delimiterCharacters());
            delims = delims.substring(0, 3) + "\n" + delims.substring(4);
            copy.put(SchemaJavaValues.delimiterCharacters(), delims);
            System.out.println("Acknowledgment message(s):");
            System.out.println(((DocumentTest)test).printAck(copy));
            Map messages = (Map)result2.get(EdifactSchemaDefs.messagesMap());
            if (messages != null && messages.size() > 0) {
                if (print) {
                    StringWriter writer = new StringWriter();
                    YamlSupport.writeMap(result2, writer);
                    String output = writer.toString();
                    System.out.println("Message data:");
                    System.out.println(output);
                }
                TestEdifactDocument.checkWrite(test, input, result2);
            } else {
                System.out.println("Message data not present");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

