/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import spire.math.Natural;
import spire.math.NaturalAlgebra;
import spire.math.NaturalInstances;
import spire.math.NaturalInstances$class;
import spire.math.NumberTag;
import spire.math.UInt;
import spire.math.UInt$;

public final class Natural$
implements NaturalInstances,
Serializable {
    public static final Natural$ MODULE$;
    private final int denom;
    private final Natural ten18;
    private final Natural zero;
    private final Natural one;
    private final NaturalAlgebra NaturalAlgebra;
    private final NumberTag.CustomTag<Natural> NaturalTag;

    static {
        new Natural$();
    }

    @Override
    public final NaturalAlgebra NaturalAlgebra() {
        return this.NaturalAlgebra;
    }

    @Override
    public final NumberTag.CustomTag<Natural> NaturalTag() {
        return this.NaturalTag;
    }

    @Override
    public final void spire$math$NaturalInstances$_setter_$NaturalAlgebra_$eq(NaturalAlgebra x$1) {
        this.NaturalAlgebra = x$1;
    }

    @Override
    public final void spire$math$NaturalInstances$_setter_$NaturalTag_$eq(NumberTag.CustomTag x$1) {
        this.NaturalTag = x$1;
    }

    public final int denom() {
        return this.denom;
    }

    public BigInt naturalToBigInt(Natural n) {
        return n.toBigInt();
    }

    public Natural apply(Seq<UInt> us) {
        if (us.isEmpty()) {
            throw new IllegalArgumentException("invalid arguments");
        }
        return ((TraversableOnce)us.tail()).foldLeft(new Natural.End(((UInt)us.head()).signed()), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Natural.Digit apply(Natural n, int u) {
                return new Natural.Digit(u, n);
            }
        });
    }

    public Natural apply(long n) {
        Natural natural;
        if ((n & 0xFFFFFFFFL) == n) {
            int n2 = (int)n;
            UInt$ uInt$ = UInt$.MODULE$;
            Natural.End end = new Natural.End(n2);
            natural = end;
        } else {
            int n3 = (int)n;
            UInt$ uInt$ = UInt$.MODULE$;
            int n4 = (int)(n >> 32);
            UInt$ uInt$2 = UInt$.MODULE$;
            Natural.Digit digit = new Natural.Digit(n3, new Natural.End(n4));
            natural = digit;
        }
        return natural;
    }

    public Natural apply(BigInt n) {
        Natural natural;
        if (n.$less(BigInt$.MODULE$.int2bigInt(0))) {
            Predef$ predef$ = Predef$.MODULE$;
            throw new IllegalArgumentException(new StringOps("negative numbers not allowed: %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{n})));
        }
        if (n.$less(BigInt$.MODULE$.long2bigInt(0xFFFFFFFFL))) {
            long l = n.toLong();
            UInt$ uInt$ = UInt$.MODULE$;
            Natural.End end = new Natural.End((int)l);
            natural = end;
        } else {
            long l = n.$amp(BigInt$.MODULE$.long2bigInt(0xFFFFFFFFL)).toLong();
            UInt$ uInt$ = UInt$.MODULE$;
            Natural.Digit digit = new Natural.Digit((int)l, this.apply(n.$greater$greater(32)));
            natural = digit;
        }
        return natural;
    }

    private Natural ten18() {
        return this.ten18;
    }

    public Natural apply(String s2) {
        return this.parse$1(this.apply(0L), s2, this.apply(1L));
    }

    public Natural zero() {
        return this.zero;
    }

    public Natural one() {
        return this.one;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Natural parse$1(Natural sofar, String s2, Natural m) {
        while (true) {
            if (s2.length() <= 18) {
                Predef$ predef$ = Predef$.MODULE$;
                return this.apply(new StringOps(s2).toLong()).$times(m).$plus(sofar);
            }
            String p = s2.substring(s2.length() - 18, s2.length());
            String r = s2.substring(0, s2.length() - 18);
            Predef$ predef$ = Predef$.MODULE$;
            Natural natural = this.apply(new StringOps(p).toLong()).$times(m).$plus(sofar);
            m = m.$times(this.ten18());
            s2 = r;
            sofar = natural;
        }
    }

    private Natural$() {
        MODULE$ = this;
        NaturalInstances$class.$init$(this);
        UInt$ uInt$ = UInt$.MODULE$;
        this.denom = 1000000000;
        this.ten18 = this.apply(1000000000000000000L);
        this.zero = this.apply(0L);
        this.one = this.apply(1L);
    }
}

