/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.DelimiterLexer;
import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.LexicalException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;

public class HL7Lexer
extends DelimiterLexer {
    public HL7Lexer(InputStream is, int subst) {
        super(is, -1);
        this.substitutionChar = subst;
        this.segmentTerminator = (char)13;
    }

    @Override
    protected void handleEscape() throws IOException {
        block12: {
            int code;
            block11: {
                int value2;
                code = this.reader.read();
                if (code < 0) {
                    throw new LexicalException("end of input in escape sequence");
                }
                StringBuilder builder = new StringBuilder();
                while ((value2 = this.reader.read()) >= 0 && value2 != this.releaseIndicator) {
                    builder.append((char)value2);
                }
                if (value2 < 0) {
                    throw new LexicalException("malformed escape sequence in input");
                }
                char rls = (char)this.releaseIndicator;
                if (builder.length() != 0) break block11;
                switch (code) {
                    case 69: {
                        this.peekToken.append(rls);
                        break block12;
                    }
                    case 70: {
                        this.peekToken.append(this.dataSeparator);
                        break block12;
                    }
                    case 82: {
                        this.peekToken.append((char)this.repetitionSeparator);
                        break block12;
                    }
                    case 83: {
                        this.peekToken.append(this.componentSeparator);
                        break block12;
                    }
                    case 84: {
                        this.peekToken.append((char)this.subCompSeparator);
                        break block12;
                    }
                    case 72: 
                    case 78: {
                        this.peekToken.append(rls);
                        this.peekToken.append((char)code);
                        this.peekToken.append(rls);
                        break block12;
                    }
                    default: {
                        throw new LexicalException("unsupported escape sequence code " + (char)code);
                    }
                }
            }
            throw new LexicalException("unsupported escape sequence code " + (char)code);
        }
    }

    public void setEncoding(Charset charSet) {
        this.reader = new InputStreamReader(this.stream, charSet);
    }

    public String init(Map<String, Object> props) throws LexicalException {
        try {
            byte[] byts = this.readBytes(3);
            String tag = new String(byts, EdiConstants.ASCII_CHARSET);
            if (!"MSH".equals(tag)) {
                throw new RuntimeException("Message does not start with 'MSH'");
            }
            byts = this.readBytes(5);
            this.dataSeparator = (char)byts[0];
            this.componentSeparator = (char)byts[1];
            this.repetitionSeparator = (char)byts[2];
            this.releaseIndicator = (char)byts[3];
            this.subCompSeparator = (char)byts[4];
            if (this.stream.read() != this.dataSeparator) {
                throw new RuntimeException("Field separator not present following MSH-01");
            }
            this.segmentTag = "MSH";
            this.reader = new ByteReader();
            this.advance(EdiConstants.ItemType.DATA_ELEMENT);
            this.elementNumber = 2;
            return new String(byts, EdiConstants.ASCII_CHARSET);
        }
        catch (IOException e) {
            throw new LexicalException("Message aborted due to error reading header", e);
        }
    }

    public void term(Map<String, Object> props) throws IOException {
    }

    private class ByteReader
    extends Reader {
        private ByteReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int chr;
            int actual = -1;
            while (actual < len - 1 && (chr = HL7Lexer.this.stream.read()) >= 0) {
                cbuf[off + ++actual] = (char)chr;
            }
            return actual;
        }

        @Override
        public void close() throws IOException {
            HL7Lexer.this.stream.close();
        }
    }

    public static enum InterchangeEndStatus {
        VALID,
        GROUP_COUNT_ERROR,
        CONTROL_NUMBER_ERROR;

    }
}

