/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.logging.log4j.core.util.Throwables;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T extends AccessibleObject> boolean isAccessible(T member) {
        Objects.requireNonNull(member, "No member provided");
        return Modifier.isPublic(((Member)((Object)member)).getModifiers()) && Modifier.isPublic(((Member)((Object)member)).getDeclaringClass().getModifiers());
    }

    public static <T extends AccessibleObject> void makeAccessible(T member) {
        if (!ReflectionUtil.isAccessible(member) && !member.isAccessible()) {
            member.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field2) {
        Objects.requireNonNull(field2, "No field provided");
        if (!(ReflectionUtil.isAccessible(field2) && !Modifier.isFinal(field2.getModifiers()) || field2.isAccessible())) {
            field2.setAccessible(true);
        }
    }

    public static Object getFieldValue(Field field2, Object instance) {
        ReflectionUtil.makeAccessible(field2);
        if (!Modifier.isStatic(field2.getModifiers())) {
            Objects.requireNonNull(instance, "No instance given for non-static field");
        }
        try {
            return field2.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static Object getStaticFieldValue(Field field2) {
        return ReflectionUtil.getFieldValue(field2, null);
    }

    public static void setFieldValue(Field field2, Object instance, Object value2) {
        ReflectionUtil.makeAccessible(field2);
        if (!Modifier.isStatic(field2.getModifiers())) {
            Objects.requireNonNull(instance, "No instance given for non-static field");
        }
        try {
            field2.set(instance, value2);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static void setStaticFieldValue(Field field2, Object value2) {
        ReflectionUtil.setFieldValue(field2, null, value2);
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) {
        Objects.requireNonNull(clazz, "No class provided");
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            ReflectionUtil.makeAccessible(constructor);
            return constructor;
        }
        catch (NoSuchMethodException ignored) {
            try {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                ReflectionUtil.makeAccessible(constructor);
                return constructor;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static <T> T instantiate(Class<T> clazz) {
        Objects.requireNonNull(clazz, "No class provided");
        Constructor<T> constructor = ReflectionUtil.getDefaultConstructor(clazz);
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException | LinkageError e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            Throwables.rethrow(e.getCause());
            throw new InternalError("Unreachable");
        }
    }
}

