/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.Stream$Empty$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import spire.math.NumberTag;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.Real;
import spire.math.Real$;
import spire.math.RealAlgebra;
import spire.math.RealInstances;
import spire.math.RealInstances$class;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.package$;

public final class Real$
implements RealInstances,
Serializable {
    public static final Real$ MODULE$;
    private final Real zero;
    private final Real one;
    private final Real two;
    private final Real four;
    private Real pi;
    private Real e;
    private Real phi;
    private Real piBy2;
    private Real piBy4;
    private Real log2;
    private Real sqrt1By2;
    private final RealAlgebra algebra;
    private final NumberTag.LargeTag<Real> RealTag;
    private volatile byte bitmap$0;

    static {
        new Real$();
    }

    private Real pi$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.pi = this.apply(16).$times(this.atan(this.apply(Rational$.MODULE$.apply(1L, 5L)))).$minus(this.four().$times(this.atan(this.apply(Rational$.MODULE$.apply(1L, 239L)))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.pi;
        }
    }

    private Real e$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.e = this.exp(this.one());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.e;
        }
    }

    private Real phi$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.phi = this.one().$plus(this.apply(5).sqrt()).$div(this.two());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.phi;
        }
    }

    private Real piBy2$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.piBy2 = this.div2n(this.pi(), 1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.piBy2;
        }
    }

    private Real piBy4$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.piBy4 = this.div2n(this.pi(), 2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.piBy4;
        }
    }

    private Real log2$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.log2 = this.div2n(this.logDrx(this.two().reciprocal()), 1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log2;
        }
    }

    private Real sqrt1By2$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.sqrt1By2 = this.two().reciprocal().sqrt();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.sqrt1By2;
        }
    }

    @Override
    public final RealAlgebra algebra() {
        return this.algebra;
    }

    @Override
    public final NumberTag.LargeTag<Real> RealTag() {
        return this.RealTag;
    }

    @Override
    public final void spire$math$RealInstances$_setter_$algebra_$eq(RealAlgebra x$1) {
        this.algebra = x$1;
    }

    @Override
    public final void spire$math$RealInstances$_setter_$RealTag_$eq(NumberTag.LargeTag x$1) {
        this.RealTag = x$1;
    }

    public Real zero() {
        return this.zero;
    }

    public Real one() {
        return this.one;
    }

    public Real two() {
        return this.two;
    }

    public Real four() {
        return this.four;
    }

    public Real apply(Function1<Object, SafeLong> f2) {
        return new Real.Inexact(f2);
    }

    public Real apply(int n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(long n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(BigInt n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(SafeLong n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(Rational n) {
        return new Real.Exact(n);
    }

    public Real apply(double n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(BigDecimal n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(String s2) {
        return new Real.Exact(Rational$.MODULE$.apply(s2));
    }

    public Real pi() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.pi$lzycompute() : this.pi;
    }

    public Real e() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.e$lzycompute() : this.e;
    }

    public Real phi() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.phi$lzycompute() : this.phi;
    }

    public Real log(Real x) {
        SafeLong t = x.apply(2);
        int n = this.sizeInBase(t, 2) - 3;
        if (t.$less(SafeLong$.MODULE$.apply(0L))) {
            throw new ArithmeticException("log of negative number");
        }
        return t.$less(SafeLong$.MODULE$.apply(4L)) ? this.log(x.reciprocal()).unary_$minus() : (t.$less(SafeLong$.MODULE$.apply(8L)) ? this.logDr(x) : this.logDr(this.div2n(x, n)).$plus(this.apply(n).$times(this.log2())));
    }

    public Real exp(Real x) {
        Real u = x.$div(this.log2());
        SafeLong n = u.apply(0);
        Real s2 = x.$minus(this.apply(n).$times(this.log2()));
        if (n.isValidInt()) {
            return n.$less(SafeLong$.MODULE$.apply(0L)) ? this.div2n(this.expDr(s2), -n.toInt()) : (n.$greater(SafeLong$.MODULE$.apply(0L)) ? this.mul2n(this.expDr(s2), n.toInt()) : this.expDr(s2));
        }
        throw new ArithmeticException("invalid power in exp");
    }

    public Real sin(Real x) {
        Real real;
        Real z = x.$div(this.piBy4());
        SafeLong s2 = this.roundUp(Rational$.MODULE$.apply(z.apply(2), SafeLong$.MODULE$.apply(4L)));
        Real y = x.$minus(this.piBy4().$times(this.apply(s2)));
        int m = s2.$percent(8L).toInt();
        int n = m < 0 ? m + 8 : m;
        switch (n) {
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
            case 7: {
                real = this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$minus(this.sinDr(y)));
                break;
            }
            case 6: {
                real = this.cosDr(y).unary_$minus();
                break;
            }
            case 5: {
                real = this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$plus(this.sinDr(y)));
                break;
            }
            case 4: {
                real = this.sinDr(y).unary_$minus();
                break;
            }
            case 3: {
                real = this.sqrt1By2().$times(this.cosDr(y).$minus(this.sinDr(y)));
                break;
            }
            case 2: {
                real = this.cosDr(y);
                break;
            }
            case 1: {
                real = this.sqrt1By2().$times(this.cosDr(y).$plus(this.sinDr(y)));
                break;
            }
            case 0: {
                real = this.sinDr(y);
            }
        }
        return real;
    }

    public Real cos(Real x) {
        Real real;
        Real z = x.$div(this.piBy4());
        SafeLong s2 = this.roundUp(Rational$.MODULE$.apply(z.apply(2), SafeLong$.MODULE$.apply(4L)));
        Real y = x.$minus(this.piBy4().$times(this.apply(s2)));
        int m = s2.$percent(8L).toInt();
        int n = m < 0 ? m + 8 : m;
        switch (n) {
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
            case 7: {
                real = this.sqrt1By2().$times(this.cosDr(y).$plus(this.sinDr(y)));
                break;
            }
            case 6: {
                real = this.sinDr(y);
                break;
            }
            case 5: {
                real = this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$minus(this.sinDr(y)));
                break;
            }
            case 4: {
                real = this.cosDr(y).unary_$minus();
                break;
            }
            case 3: {
                real = this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$plus(this.sinDr(y)));
                break;
            }
            case 2: {
                real = this.sinDr(y).unary_$minus();
                break;
            }
            case 1: {
                real = this.sqrt1By2().$times(this.cosDr(y).$minus(this.sinDr(y)));
                break;
            }
            case 0: {
                real = this.cosDr(y);
            }
        }
        return real;
    }

    public Real tan(Real x) {
        return this.sin(x).$div(this.cos(x));
    }

    public Real atan(Real x) {
        Real real;
        SafeLong t = x.apply(2);
        Real xp1 = x.$plus(this.one());
        Real xm1 = x.$minus(this.one());
        if (t.$less(SafeLong$.MODULE$.apply(-5L))) {
            real = this.atanDr(x.reciprocal().unary_$minus()).$minus(this.piBy2());
        } else {
            SafeLong safeLong = t;
            Integer n = BoxesRunTime.boxToInteger(-4);
            if (safeLong != null && safeLong.equals(n)) {
                real = this.piBy4().unary_$minus().$minus(this.atanDr(xp1.$div(xm1)));
            } else if (t.$less(SafeLong$.MODULE$.apply(4L))) {
                real = this.atanDr(x);
            } else {
                SafeLong safeLong2 = t;
                Integer n2 = BoxesRunTime.boxToInteger(4);
                real = safeLong2 != null && safeLong2.equals(n2) ? this.piBy4().$plus(this.atanDr(xm1.$div(xp1))) : this.piBy2().$minus(this.atanDr(x.reciprocal()));
            }
        }
        return real;
    }

    public Real atan2(Real y, Real x) {
        Serializable serializable = new Serializable(y, x){
            private final Real y$1;
            private final Real x$7;

            public final SafeLong apply(int p) {
                block8: {
                    SafeLong safeLong;
                    block4: {
                        int sy;
                        block7: {
                            block6: {
                                int sx;
                                block5: {
                                    block3: {
                                        int pp2 = p;
                                        sx = this.x$7.apply(p).signum();
                                        sy = this.y$1.apply(p).signum();
                                        while (sx == 0 && sy == 0) {
                                            sx = this.x$7.apply(pp2).signum();
                                            sy = this.y$1.apply(pp2).signum();
                                            ++pp2;
                                        }
                                        if (sx <= 0) break block3;
                                        safeLong = Real$.MODULE$.atan(this.y$1.$div(this.x$7)).apply(p);
                                        break block4;
                                    }
                                    if (sy < 0 || sx >= 0) break block5;
                                    safeLong = Real$.MODULE$.atan(this.y$1.$div(this.x$7)).$plus(Real$.MODULE$.pi()).apply(p);
                                    break block4;
                                }
                                if (sy >= 0 || sx >= 0) break block6;
                                safeLong = Real$.MODULE$.atan(this.y$1.$div(this.x$7)).$minus(Real$.MODULE$.pi()).apply(p);
                                break block4;
                            }
                            if (sy <= 0) break block7;
                            safeLong = Real$.MODULE$.pi().$div(Real$.MODULE$.two()).apply(p);
                            break block4;
                        }
                        if (sy >= 0) break block8;
                        safeLong = Real$.MODULE$.pi().unary_$minus().$div(Real$.MODULE$.two()).apply(p);
                    }
                    return safeLong;
                }
                throw new IllegalArgumentException("atan2(0, 0) is undefined");
            }
            {
                this.y$1 = y$1;
                this.x$7 = x$7;
            }
        };
        Real$ real$ = this;
        return new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
    }

    public Real asin(Real x) {
        SafeLong x0 = x.apply(0);
        Real s2 = this.one().$minus(x.$times(x)).sqrt();
        int n = x0.signum();
        Real real = n > 0 ? this.pi().$div(this.two()).$minus(this.atan(s2.$div(x))) : (0 == n ? this.atan(x.$div(s2)) : this.pi().unary_$minus().$div(this.two()).$minus(this.atan(s2.$div(x))));
        return real;
    }

    public Real acos(Real x) {
        return this.pi().$div(this.two()).$minus(this.asin(x));
    }

    public Real sinh(Real x) {
        Real y = this.exp(x);
        return y.$minus(y.reciprocal()).$div(this.two());
    }

    public Real cosh(Real x) {
        Real y = this.exp(x);
        return y.$plus(y.reciprocal()).$div(this.two());
    }

    public Real tanh(Real x) {
        Real y = this.exp(x);
        Real y2 = y.reciprocal();
        return y.$minus(y2).$div(y.$plus(y2));
    }

    public Real asinh(Real x) {
        return this.log(x.$plus(x.$times(x).$plus(this.one()).sqrt()));
    }

    public Real acosh(Real x) {
        return this.log(x.$plus(x.$times(x).$minus(this.one()).sqrt()));
    }

    public Real atanh(Real x) {
        return this.log(this.one().$plus(x).$div(this.one().$minus(x))).$div(this.two());
    }

    public int digits() {
        return 40;
    }

    public int bits() {
        return this.digitsToBits(this.digits());
    }

    public int digitsToBits(int n) {
        return (int)package$.MODULE$.ceil((double)n * (package$.MODULE$.log(10.0) / package$.MODULE$.log(2.0))) + 4;
    }

    public int sizeInBase(SafeLong n, int base) {
        return this.loop$2(n.abs(), 0, base);
    }

    public SafeLong roundUp(Rational r) {
        return SafeLong$.MODULE$.apply(r.round().toBigInt());
    }

    public Real div2n(Real x, int n) {
        Serializable serializable = new Serializable(x, n){
            private final Real x$5;
            private final int n$1;

            public final SafeLong apply(int p) {
                return p >= this.n$1 ? this.x$5.apply(p - this.n$1) : Real$.MODULE$.roundUp(Rational$.MODULE$.apply(this.x$5.apply(p), SafeLong$.MODULE$.two().pow(this.n$1)));
            }
            {
                this.x$5 = x$5;
                this.n$1 = n$1;
            }
        };
        Real$ real$ = this;
        return new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
    }

    public Real mul2n(Real x, int n) {
        Serializable serializable = new Serializable(x, n){
            private final Real x$6;
            private final int n$2;

            public final SafeLong apply(int p) {
                return this.x$6.apply(p + this.n$2);
            }
            {
                this.x$6 = x$6;
                this.n$2 = n$2;
            }
        };
        Real$ real$ = this;
        return new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
    }

    public Real piBy2() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.piBy2$lzycompute() : this.piBy2;
    }

    public Real piBy4() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.piBy4$lzycompute() : this.piBy4;
    }

    public Real log2() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.log2$lzycompute() : this.log2;
    }

    public Real sqrt1By2() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.sqrt1By2$lzycompute() : this.sqrt1By2;
    }

    public SafeLong accumulate(SafeLong total2, Stream<SafeLong> xs, Stream<Rational> cs) {
        while (true) {
            SafeLong t;
            Option<Tuple2<Rational, Stream<Rational>>> option2;
            Option<Tuple2<SafeLong, Stream<SafeLong>>> option3;
            block7: {
                block6: {
                    Tuple2<Stream<SafeLong>, Stream<Rational>> tuple22;
                    if (((Object)Stream$Empty$.MODULE$).equals((tuple22 = new Tuple2<Stream<SafeLong>, Stream<Rational>>(xs, cs))._2())) break block6;
                    if (((Object)Stream$Empty$.MODULE$).equals(tuple22._1())) {
                        throw scala.sys.package$.MODULE$.error("nooooo");
                    }
                    option3 = scala.package$.MODULE$.$hash$colon$colon().unapply(tuple22._1());
                    if (option3.isEmpty() || (option2 = scala.package$.MODULE$.$hash$colon$colon().unapply(tuple22._2())).isEmpty()) {
                        throw new MatchError(tuple22);
                    }
                    SafeLong safeLong = t = this.roundUp(option2.get()._1().$times(Rational$.MODULE$.apply(option3.get()._1())));
                    Integer n = BoxesRunTime.boxToInteger(0);
                    if (safeLong == null || !safeLong.equals(n)) break block7;
                }
                return total2;
            }
            cs = option2.get()._2();
            xs = option3.get()._2();
            total2 = total2.$plus(t);
        }
    }

    public Real powerSeries(Stream<Rational> ps, Function1<Object, Object> terms2, Real x) {
        Serializable serializable = new Serializable(ps, terms2, x){
            private final Stream ps$1;
            private final Function1 terms$1;
            private final Real x$8;

            public final SafeLong apply(int p) {
                SafeLong xn;
                int t = this.terms$1.apply$mcII$sp(p);
                int l2t = 2 * Real$.MODULE$.sizeInBase(SafeLong$.MODULE$.apply(t).$plus(1L), 2) + 6;
                int p2 = p + l2t;
                SafeLong xr = this.x$8.apply(p2);
                SafeLong safeLong = xn = SafeLong$.MODULE$.two().pow(p2);
                Integer n = BoxesRunTime.boxToInteger(0);
                if (safeLong != null && safeLong.equals(n)) {
                    throw scala.sys.package$.MODULE$.error("oh no");
                }
                SafeLong num = Real$.MODULE$.accumulate(SafeLong$.MODULE$.zero(), scala.package$.MODULE$.Stream().iterate(xn, new Serializable(this, xr, xn){
                    private final /* synthetic */ anonfun.powerSeries.1 $outer;
                    private final SafeLong xr$1;
                    private final SafeLong xn$1;

                    public final SafeLong apply(SafeLong yn) {
                        SafeLong safeLong = this.xn$1;
                        SafeLong safeLong2 = this.xr$1;
                        return Real$.MODULE$.roundUp(Rational$.MODULE$.apply(yn.$times(safeLong2), safeLong));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.xr$1 = xr$1;
                        this.xn$1 = xn$1;
                    }
                }), (Stream<Rational>)this.ps$1.take(t));
                SafeLong denom = SafeLong$.MODULE$.two().pow(l2t);
                return Real$.MODULE$.roundUp(Rational$.MODULE$.apply(num, denom));
            }

            public final SafeLong spire$math$Real$$anonfun$$g$1(SafeLong yn, SafeLong xr$1, SafeLong xn$1) {
                return Real$.MODULE$.roundUp(Rational$.MODULE$.apply(yn.$times(xr$1), xn$1));
            }
            {
                this.ps$1 = ps$1;
                this.terms$1 = terms$1;
                this.x$8 = x$8;
            }
        };
        Real$ real$ = this;
        return new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable));
    }

    public Stream<Rational> accSeq(Function2<Rational, SafeLong, Rational> f2) {
        return this.spire$math$Real$$loop$3(Rational$.MODULE$.one(), SafeLong$.MODULE$.one(), f2);
    }

    public Real expDr(Real x) {
        Serializable serializable = new Serializable(){

            public final Rational apply(Rational r, SafeLong n) {
                return r.$div(Rational$.MODULE$.apply(n));
            }
        };
        Serializable serializable2 = new Serializable(){

            public final int apply(int n) {
                return n;
            }

            public int apply$mcII$sp(int n) {
                return n;
            }
        };
        Stream stream2 = this.spire$math$Real$$loop$3(Rational$.MODULE$.one(), SafeLong$.MODULE$.one(), (Function2)((Object)serializable));
        Serializable serializable3 = new /* invalid duplicate definition of identical inner class */;
        Real$ real$ = this;
        return new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable3));
    }

    public Real logDr(Real x) {
        Real y = x.$minus(this.one()).$div(x);
        return y.$times(this.logDrx(y));
    }

    public Real logDrx(Real x) {
        Serializable serializable = new Serializable(){

            public final int apply(int x$3) {
                return x$3 + 1;
            }

            public int apply$mcII$sp(int x$3) {
                return x$3 + 1;
            }
        };
        Stream stream2 = scala.package$.MODULE$.Stream().from(1).map(new Serializable(){

            public final Rational apply(int n) {
                return Rational$.MODULE$.apply(1L, n);
            }
        }, Stream$.MODULE$.canBuildFrom());
        Serializable serializable2 = new /* invalid duplicate definition of identical inner class */;
        Real$ real$ = this;
        return new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable2));
    }

    public Real sinDr(Real x) {
        Serializable serializable = new Serializable(){

            public final Rational apply(Rational r, SafeLong n) {
                return r.unary_$minus().$times(Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(1L), SafeLong$.MODULE$.apply(2L).$times(n).$times(SafeLong$.MODULE$.apply(2L).$times(n).$plus(1L))));
            }
        };
        Real real = x.$times(x);
        Serializable serializable2 = new Serializable(){

            public final int apply(int n) {
                return n;
            }

            public int apply$mcII$sp(int n) {
                return n;
            }
        };
        Stream stream2 = this.spire$math$Real$$loop$3(Rational$.MODULE$.one(), SafeLong$.MODULE$.one(), (Function2)((Object)serializable));
        Serializable serializable3 = new /* invalid duplicate definition of identical inner class */;
        Real$ real$ = this;
        return x.$times(new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable3)));
    }

    public Real cosDr(Real x) {
        Serializable serializable = new Serializable(){

            public final Rational apply(Rational r, SafeLong n) {
                return r.unary_$minus().$times(Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(1L), SafeLong$.MODULE$.apply(2L).$times(n).$times(SafeLong$.MODULE$.apply(2L).$times(n).$minus(1L))));
            }
        };
        Real real = x.$times(x);
        Serializable serializable2 = new Serializable(){

            public final int apply(int n) {
                return n;
            }

            public int apply$mcII$sp(int n) {
                return n;
            }
        };
        Stream stream2 = this.spire$math$Real$$loop$3(Rational$.MODULE$.one(), SafeLong$.MODULE$.one(), (Function2)((Object)serializable));
        Serializable serializable3 = new /* invalid duplicate definition of identical inner class */;
        Real$ real$ = this;
        return new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable3));
    }

    public Real atanDr(Real x) {
        Real y = x.$times(x).$plus(this.apply(1));
        return x.$div(y).$times(this.atanDrx(x.$times(x).$div(y)));
    }

    public Real atanDrx(Real x) {
        Serializable serializable = new Serializable(){

            public final Rational apply(Rational r, SafeLong n) {
                return r.$times(Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(2L).$times(n), SafeLong$.MODULE$.apply(2L).$times(n).$plus(1L)));
            }
        };
        Serializable serializable2 = new Serializable(){

            public final int apply(int x$4) {
                return x$4 * 2;
            }

            public int apply$mcII$sp(int x$4) {
                return x$4 * 2;
            }
        };
        Stream stream2 = this.spire$math$Real$$loop$3(Rational$.MODULE$.one(), SafeLong$.MODULE$.one(), (Function2)((Object)serializable));
        Serializable serializable3 = new /* invalid duplicate definition of identical inner class */;
        Real$ real$ = this;
        return new Real.Inexact((Function1<Object, SafeLong>)((Object)serializable3));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final int loop$2(SafeLong n, int acc, int base$1) {
        while (!n.$less$eq(SafeLong$.MODULE$.apply(1L))) {
            ++acc;
            n = n.$div(base$1);
        }
        return acc + 1;
    }

    public final Stream spire$math$Real$$loop$3(Rational r, SafeLong n, Function2 f$1) {
        return Stream$.MODULE$.consWrapper(new Serializable(f$1, r, n){
            private final Function2 f$1;
            private final Rational r$1;
            private final SafeLong n$3;

            public final Stream<Rational> apply() {
                return Real$.MODULE$.spire$math$Real$$loop$3((Rational)this.f$1.apply(this.r$1, this.n$3), this.n$3.$plus(1L), this.f$1);
            }
            {
                this.f$1 = f$1;
                this.r$1 = r$1;
                this.n$3 = n$3;
            }
        }).$hash$colon$colon(r);
    }

    private Real$() {
        MODULE$ = this;
        RealInstances$class.$init$(this);
        this.zero = new Real.Exact(Rational$.MODULE$.zero());
        this.one = new Real.Exact(Rational$.MODULE$.one());
        this.two = new Real.Exact(Rational$.MODULE$.apply(2));
        this.four = new Real.Exact(Rational$.MODULE$.apply(4));
    }
}

