/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.TypeFormatBase;
import java.io.IOException;

public abstract class StringFormatBase
extends TypeFormatBase {
    protected final TypeFormatConstants.FillMode spaceFill;

    public StringFormatBase(String code2, int min2, int max2, TypeFormatConstants.FillMode fill2) {
        super(code2, min2, max2);
        this.spaceFill = fill2;
        if (this.spaceFill.numberOnly()) {
            throw new IllegalArgumentException("Numeric fill option not supported");
        }
    }

    public abstract Object parseToken(LexerBase var1) throws LexicalException;

    public abstract String buildToken(Object var1, WriterBase var2) throws LexicalException;

    @Override
    public Object parse(LexerBase lexer) throws LexicalException {
        this.checkInputLength(lexer);
        switch (this.spaceFill) {
            case LEFT: {
                StringFormatBase.stripSpaceRight(lexer.tokenBuilder());
                break;
            }
            case RIGHT: {
                StringFormatBase.stripSpaceLeft(lexer.tokenBuilder());
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Invalid string format fill setting");
            }
        }
        return this.parseToken(lexer);
    }

    @Override
    public void write(Object value2, WriterBase writer) throws IOException {
        String text2 = this.buildToken(value2, writer);
        writer.startToken();
        switch (this.spaceFill) {
            case LEFT: {
                text2 = this.checkOutputMaxLength(text2, writer);
                writer.writeEscaped(text2);
                StringFormatBase.writePadding(this.minLength - text2.length(), SPACES, writer);
                break;
            }
            case RIGHT: {
                text2 = this.checkOutputMaxLength(text2, writer);
                StringFormatBase.writePadding(this.minLength - text2.length(), SPACES, writer);
                writer.writeEscaped(text2);
                break;
            }
            case NONE: {
                text2 = this.checkOutputLength(text2, writer);
                writer.writeEscaped(text2);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid string format fill setting");
            }
        }
    }
}

