/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.TypeFormatBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public abstract class NumberFormatBase
extends TypeFormatBase {
    protected final TypeFormatConstants.NumberSign signType;
    protected final boolean countSign;
    protected final TypeFormatConstants.FillMode fillMode;

    public NumberFormatBase(String code2, int min2, int max2, TypeFormatConstants.NumberSign sign2, boolean count2, TypeFormatConstants.FillMode pad) {
        super(code2, min2, max2);
        this.signType = sign2;
        this.countSign = count2;
        this.fillMode = pad;
    }

    protected int stripPadding(LexerBase lexer) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        int start = builder.length();
        switch (this.fillMode) {
            case RIGHT: {
                NumberFormatBase.stripSpaceLeft(builder);
                break;
            }
            case LEFT: {
                NumberFormatBase.stripSpaceRight(builder);
                break;
            }
        }
        int spaces2 = start - builder.length();
        if (builder.length() == 0) {
            this.noValuePresent(lexer);
            builder.append('0');
        }
        return spaces2;
    }

    protected void missingRequiredSign(LexerBase lexer) throws LexicalException {
        lexer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "missing required sign");
    }

    protected void plusNotAllowed(LexerBase lexer) throws LexicalException {
        lexer.error(this, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "plus sign (+) not allowed");
        lexer.tokenBuilder().delete(0, 1);
    }

    protected void minusNotAllowed(LexerBase lexer) throws LexicalException {
        lexer.error(this, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "minus sign (-) not allowed");
        lexer.tokenBuilder().delete(0, 1);
    }

    protected boolean signToNormalForm(LexerBase lexer) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        boolean signed = false;
        int index2 = this.signType.trailingSign() ? builder.length() - 1 : 0;
        char chr = builder.charAt(index2);
        if (chr == '-') {
            if (this.signType.useMinus()) {
                signed = true;
            } else {
                this.minusNotAllowed(lexer);
                builder.deleteCharAt(index2);
            }
        } else if (chr == '+') {
            if (this.signType.acceptPlus()) {
                signed = true;
            } else {
                this.plusNotAllowed(lexer);
                builder.deleteCharAt(index2);
            }
        } else if (this.signType.forceSign()) {
            this.missingRequiredSign(lexer);
        }
        if (signed && this.signType.trailingSign()) {
            builder.deleteCharAt(index2);
            builder.insert(0, chr);
        }
        return signed;
    }

    protected void validateLength(int length, LexerBase lexer) throws LexicalException {
        if (length < this.minLength) {
            this.tooShort(length, lexer);
        }
        if (length > this.maxLength) {
            this.tooLong(length, lexer);
            lexer.tokenBuilder().setLength(this.maxLength);
        }
    }

    protected int checkIntegerFormat(LexerBase lexer) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        int spaces2 = this.stripPadding(lexer);
        int digits = 0;
        boolean number2 = false;
        for (int index2 = (signed = this.signToNormalForm(lexer)) ? 1 : 0; index2 < builder.length(); ++index2) {
            char chr = builder.charAt(index2);
            if (chr >= '0' && chr <= '9') {
                number2 = true;
                if (digits <= 0 && chr == '0') continue;
                ++digits;
                continue;
            }
            this.invalidCharacter(chr, lexer);
            builder.deleteCharAt(index2--);
        }
        if (!number2) {
            this.noValuePresent(lexer);
            lexer.tokenBuilder().append('0');
        } else {
            boolean signed;
            int length = builder.length() - (!this.countSign && signed ? 1 : 0) + spaces2;
            this.validateLength(length, lexer);
        }
        return digits;
    }

    protected Object convertSizedInteger(LexerBase lexer, int digits) {
        String text2 = lexer.token();
        if (digits < 10) {
            return Integer.valueOf(text2);
        }
        if (digits < 20) {
            return Long.valueOf(text2);
        }
        return new BigInteger(text2);
    }

    protected Object convertPlainDecimal(LexerBase lexer) throws LexicalException {
        char last2;
        StringBuilder builder = lexer.tokenBuilder();
        this.stripPadding(lexer);
        boolean signed = this.signToNormalForm(lexer);
        boolean number2 = false;
        int digits = 0;
        boolean decimal = false;
        int altmark = lexer.getAltDecimalMark();
        for (int index2 = signed ? 1 : 0; index2 < builder.length(); ++index2) {
            char chr = builder.charAt(index2);
            if (chr >= '0' && chr <= '9') {
                number2 = true;
                if (digits <= 0 && chr == '0') continue;
                ++digits;
                continue;
            }
            if (!(decimal || chr != '.' && chr != altmark)) {
                decimal = true;
                if (chr != altmark) continue;
                builder.setCharAt(index2, '.');
                continue;
            }
            if (index2 == 0 && signed) continue;
            this.invalidCharacter(chr, lexer);
            builder.deleteCharAt(index2--);
        }
        if (!number2) {
            this.noValuePresent(lexer);
            builder.append('0');
        }
        if (!decimal) {
            lexer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "missing required decimal mark");
        }
        if ((last2 = builder.charAt(builder.length() - 1)) == '.' || last2 == altmark) {
            builder.deleteCharAt(builder.length() - 1);
            return this.convertSizedInteger(lexer, digits);
        }
        return new BigDecimal(lexer.token());
    }

    protected void writePadded(String text2, int length, boolean negate2, WriterBase writer) throws IOException {
        int effect = length;
        if (this.signType == TypeFormatConstants.NumberSign.UNSIGNED && negate2) {
            writer.error(this, ErrorHandler.ErrorCondition.INVALID_VALUE, "negative value not allowed");
            negate2 = false;
        }
        if (this.countSign) {
            switch (this.signType) {
                case ALWAYS_LEFT: 
                case ALWAYS_RIGHT: {
                    ++effect;
                    break;
                }
                default: {
                    if (!negate2) break;
                    ++effect;
                }
            }
        }
        if (effect > this.maxLength) {
            this.tooLong(effect, writer);
            int trim2 = Math.max(text2.length() - effect + this.maxLength, 0);
            text2 = text2.substring(0, trim2);
            effect = this.maxLength;
        }
        int pad = this.minLength - effect;
        if (this.fillMode == TypeFormatConstants.FillMode.ZEROES) {
            switch (this.signType) {
                case ALWAYS_LEFT: {
                    writer.writeEscaped(negate2 ? "-" : "+");
                    break;
                }
                case NEGATIVE_ONLY: 
                case OPTIONAL: {
                    if (!negate2) break;
                    writer.writeEscaped("-");
                    break;
                }
            }
            NumberFormatBase.writePadding(pad, ZEROES, writer);
            writer.writeEscaped(text2);
            if (this.signType == TypeFormatConstants.NumberSign.ALWAYS_RIGHT) {
                writer.writeEscaped(negate2 ? "-" : "+");
            }
        } else {
            if (this.fillMode == TypeFormatConstants.FillMode.RIGHT) {
                NumberFormatBase.writePadding(pad, SPACES, writer);
            }
            switch (this.signType) {
                case ALWAYS_LEFT: {
                    writer.writeEscaped(negate2 ? "-" : "+");
                    writer.writeEscaped(text2);
                    break;
                }
                case ALWAYS_RIGHT: {
                    writer.writeEscaped(text2);
                    writer.writeEscaped(negate2 ? "-" : "+");
                    break;
                }
                case NEGATIVE_ONLY: 
                case OPTIONAL: {
                    if (negate2) {
                        writer.writeEscaped("-");
                    }
                    writer.writeEscaped(text2);
                    break;
                }
                case UNSIGNED: {
                    writer.writeEscaped(text2);
                }
            }
            if (this.fillMode == TypeFormatConstants.FillMode.LEFT) {
                NumberFormatBase.writePadding(pad, SPACES, writer);
            }
        }
    }

    protected void writePadded(String text2, boolean negate2, WriterBase writer) throws IOException {
        this.writePadded(text2, text2.length(), negate2, writer);
    }

    protected void writeBigInteger(BigInteger big, WriterBase writer) throws IOException {
        if (big.signum() < 0) {
            this.writePadded(big.abs().toString(), true, writer);
        } else {
            this.writePadded(big.toString(), false, writer);
        }
    }

    private static String appendSuffix(String text2, String suffix) {
        if (suffix == null) {
            return text2;
        }
        return text2 + suffix;
    }

    protected void writeIntegerValue(Object value2, String suffix, WriterBase writer) throws IOException {
        if (value2 instanceof Integer) {
            int actual = (Integer)value2;
            if (actual < 0) {
                this.writePadded(NumberFormatBase.appendSuffix(Integer.toString(-actual), suffix), true, writer);
            } else {
                this.writePadded(NumberFormatBase.appendSuffix(Integer.toString(actual), suffix), false, writer);
            }
        } else if (value2 instanceof Long) {
            long actual = (Long)value2;
            if (actual < 0L) {
                this.writePadded(NumberFormatBase.appendSuffix(Long.toString(-actual), suffix), true, writer);
            } else {
                this.writePadded(NumberFormatBase.appendSuffix(Long.toString(actual), suffix), false, writer);
            }
        } else if (value2 instanceof BigInteger) {
            BigInteger actual = (BigInteger)value2;
            if (actual.signum() < 0) {
                this.writePadded(NumberFormatBase.appendSuffix(actual.abs().toString(), suffix), true, writer);
            } else {
                this.writePadded(NumberFormatBase.appendSuffix(actual.toString(), suffix), false, writer);
            }
        } else {
            this.wrongType(value2, writer);
        }
    }

    protected void writeIntegerValue(Object value2, WriterBase writer) throws IOException {
        this.writeIntegerValue(value2, null, writer);
    }

    protected void writeDecimalValue(Object value2, WriterBase writer) throws IOException {
        if (value2 instanceof BigDecimal) {
            BigDecimal big = (BigDecimal)value2;
            int precision = big.precision();
            int scale = big.scale();
            if (scale <= 0 && precision - scale <= this.maxLength) {
                this.writeIntegerValue(big.toBigIntegerExact(), ".", writer);
            } else {
                boolean negate2;
                boolean bl = negate2 = big.signum() < 0;
                if (negate2) {
                    big = big.abs();
                }
                if (scale >= 0 && Math.max(precision, scale) <= this.maxLength) {
                    String text2 = big.toPlainString();
                    if (text2.length() > 1 && text2.charAt(0) == '0') {
                        text2 = text2.substring(1);
                    }
                    this.writePadded(text2, text2.length(), negate2, writer);
                } else {
                    int allowed = this.maxLength - 1 - (negate2 && this.countSign ? 1 : 0);
                    if (allowed + scale < 0) {
                        writer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "value representation not possible for " + ((BigDecimal)value2).toString());
                        this.writePadded("0", 1, false, writer);
                    } else {
                        writer.error(this, ErrorHandler.ErrorCondition.DATA_TRUNCATION, "rounding value to fit " + ((BigDecimal)value2).toString());
                        MathContext mc = new MathContext(allowed);
                        big.round(mc);
                        String text3 = big.toPlainString();
                        if (text3.length() > 1 && text3.charAt(0) == '0') {
                            text3 = text3.substring(1);
                        }
                        this.writePadded(text3, text3.length(), negate2, writer);
                    }
                }
            }
        } else {
            this.writeIntegerValue(value2, ".", writer);
        }
    }
}

