/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.ErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LexerBase
implements ErrorHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    final InputStream stream;
    final int altDecimalMark;
    Reader reader;
    ErrorHandler errorHandler;
    int substitutionChar;
    int groupCount;
    int segmentNumber;
    int elementNumber;
    EdiConstants.ItemType currentType;
    StringBuilder tokenBuilder;

    public LexerBase(InputStream is, int altmark) {
        this.stream = is;
        this.altDecimalMark = altmark;
        this.tokenBuilder = new StringBuilder();
    }

    public int getAltDecimalMark() {
        return this.altDecimalMark;
    }

    public void setHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public abstract void discardTo(EdiConstants.ItemType var1) throws IOException;

    public void discardSegment() throws IOException {
        this.discardTo(EdiConstants.ItemType.SEGMENT);
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable2) {}
        } else {
            try {
                this.stream.close();
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
        }
    }

    void readArray(byte[] byts, int from2) throws IOException {
        int count2;
        for (int offset = from2; byts.length > offset; offset += count2) {
            count2 = this.stream.read(byts, offset, byts.length - offset);
            if (count2 > 0) continue;
            throw new IOException("Required data missing from message");
        }
    }

    byte[] readBytes(int num) throws IOException {
        byte[] byts = new byte[num];
        this.readArray(byts, 0);
        return byts;
    }

    public int getSubstitutionChar() {
        return this.substitutionChar;
    }

    public void countGroup() {
        ++this.groupCount;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public int getElementNumber() {
        return this.elementNumber;
    }

    public EdiConstants.ItemType currentType() {
        return this.currentType;
    }

    public String token() {
        return this.tokenBuilder.toString();
    }

    public StringBuilder tokenBuilder() {
        return this.tokenBuilder;
    }
}

