/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.1.15.shade.composer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.1.15.shade.composer.ComposerException;
import org.yaml.snakeyaml.1.15.shade.events.AliasEvent;
import org.yaml.snakeyaml.1.15.shade.events.Event;
import org.yaml.snakeyaml.1.15.shade.events.MappingStartEvent;
import org.yaml.snakeyaml.1.15.shade.events.NodeEvent;
import org.yaml.snakeyaml.1.15.shade.events.ScalarEvent;
import org.yaml.snakeyaml.1.15.shade.events.SequenceStartEvent;
import org.yaml.snakeyaml.1.15.shade.nodes.MappingNode;
import org.yaml.snakeyaml.1.15.shade.nodes.Node;
import org.yaml.snakeyaml.1.15.shade.nodes.NodeId;
import org.yaml.snakeyaml.1.15.shade.nodes.NodeTuple;
import org.yaml.snakeyaml.1.15.shade.nodes.ScalarNode;
import org.yaml.snakeyaml.1.15.shade.nodes.SequenceNode;
import org.yaml.snakeyaml.1.15.shade.nodes.Tag;
import org.yaml.snakeyaml.1.15.shade.parser.Parser;
import org.yaml.snakeyaml.1.15.shade.resolver.Resolver;

public class Composer {
    private final Parser parser;
    private final Resolver resolver;
    private final Map<String, Node> anchors;
    private final Set<Node> recursiveNodes;

    public Composer(Parser parser, Resolver resolver) {
        this.parser = parser;
        this.resolver = resolver;
        this.anchors = new HashMap<String, Node>();
        this.recursiveNodes = new HashSet<Node>();
    }

    public boolean checkNode() {
        if (this.parser.checkEvent(Event.ID.StreamStart)) {
            this.parser.getEvent();
        }
        return !this.parser.checkEvent(Event.ID.StreamEnd);
    }

    public Node getNode() {
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            return this.composeDocument();
        }
        return null;
    }

    public Node getSingleNode() {
        this.parser.getEvent();
        Node document = null;
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            document = this.composeDocument();
        }
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            Event event = this.parser.getEvent();
            throw new ComposerException("expected a single document in the stream", document.getStartMark(), "but found another document", event.getStartMark());
        }
        this.parser.getEvent();
        return document;
    }

    private Node composeDocument() {
        this.parser.getEvent();
        Node node = this.composeNode(null);
        this.parser.getEvent();
        this.anchors.clear();
        this.recursiveNodes.clear();
        return node;
    }

    private Node composeNode(Node parent) {
        this.recursiveNodes.add(parent);
        if (this.parser.checkEvent(Event.ID.Alias)) {
            AliasEvent event = (AliasEvent)this.parser.getEvent();
            String anchor = event.getAnchor();
            if (!this.anchors.containsKey(anchor)) {
                throw new ComposerException(null, null, "found undefined alias " + anchor, event.getStartMark());
            }
            Node result2 = this.anchors.get(anchor);
            if (this.recursiveNodes.remove(result2)) {
                result2.setTwoStepsConstruction(true);
            }
            return result2;
        }
        NodeEvent event = (NodeEvent)this.parser.peekEvent();
        String anchor = null;
        anchor = event.getAnchor();
        Node node = null;
        node = this.parser.checkEvent(Event.ID.Scalar) ? this.composeScalarNode(anchor) : (this.parser.checkEvent(Event.ID.SequenceStart) ? this.composeSequenceNode(anchor) : this.composeMappingNode(anchor));
        this.recursiveNodes.remove(parent);
        return node;
    }

    private Node composeScalarNode(String anchor) {
        Tag nodeTag;
        ScalarEvent ev = (ScalarEvent)this.parser.getEvent();
        String tag = ev.getTag();
        boolean resolved = false;
        if (tag == null || tag.equals("!")) {
            nodeTag = this.resolver.resolve(NodeId.scalar, ev.getValue(), ev.getImplicit().canOmitTagInPlainScalar());
            resolved = true;
        } else {
            nodeTag = new Tag(tag);
        }
        ScalarNode node = new ScalarNode(nodeTag, resolved, ev.getValue(), ev.getStartMark(), ev.getEndMark(), ev.getStyle());
        if (anchor != null) {
            this.anchors.put(anchor, node);
        }
        return node;
    }

    private Node composeSequenceNode(String anchor) {
        Tag nodeTag;
        SequenceStartEvent startEvent = (SequenceStartEvent)this.parser.getEvent();
        String tag = startEvent.getTag();
        boolean resolved = false;
        if (tag == null || tag.equals("!")) {
            nodeTag = this.resolver.resolve(NodeId.sequence, null, startEvent.getImplicit());
            resolved = true;
        } else {
            nodeTag = new Tag(tag);
        }
        ArrayList<Node> children2 = new ArrayList<Node>();
        SequenceNode node = new SequenceNode(nodeTag, resolved, children2, startEvent.getStartMark(), null, startEvent.getFlowStyle());
        if (anchor != null) {
            this.anchors.put(anchor, node);
        }
        while (!this.parser.checkEvent(Event.ID.SequenceEnd)) {
            children2.add(this.composeNode(node));
        }
        Event endEvent = this.parser.getEvent();
        node.setEndMark(endEvent.getEndMark());
        return node;
    }

    private Node composeMappingNode(String anchor) {
        Tag nodeTag;
        MappingStartEvent startEvent = (MappingStartEvent)this.parser.getEvent();
        String tag = startEvent.getTag();
        boolean resolved = false;
        if (tag == null || tag.equals("!")) {
            nodeTag = this.resolver.resolve(NodeId.mapping, null, startEvent.getImplicit());
            resolved = true;
        } else {
            nodeTag = new Tag(tag);
        }
        ArrayList<NodeTuple> children2 = new ArrayList<NodeTuple>();
        MappingNode node = new MappingNode(nodeTag, resolved, children2, startEvent.getStartMark(), null, startEvent.getFlowStyle());
        if (anchor != null) {
            this.anchors.put(anchor, node);
        }
        while (!this.parser.checkEvent(Event.ID.MappingEnd)) {
            Node itemKey = this.composeNode(node);
            if (itemKey.getTag().equals(Tag.MERGE)) {
                node.setMerged(true);
            }
            Node itemValue = this.composeNode(node);
            children2.add(new NodeTuple(itemKey, itemValue));
        }
        Event endEvent = this.parser.getEvent();
        node.setEndMark(endEvent.getEndMark());
        return node;
    }
}

