/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.formats.ExplicitDecimalFormat;
import com.mulesoft.flatfile.lexical.formats.GeneralStringFormat;
import com.mulesoft.flatfile.lexical.formats.IntegerFormat;
import com.mulesoft.flatfile.lexical.formats.XmlDateFormat;

public final class HL7Support {
    private HL7Support() {
    }

    public static String typeName(String type, int minLength, int maxLength) {
        if (minLength == maxLength) {
            return type + '(' + maxLength + ')';
        }
        return type + '(' + minLength + '-' + maxLength + ')';
    }

    public static TypeFormat buildType(String type, int minLength, int maxLength) {
        String norm2 = type.toUpperCase();
        if ("ST".equals(norm2) || "VARIES".equals(norm2) || "VAR".equals(norm2)) {
            return new GeneralStringFormat(type, minLength, maxLength, TypeFormatConstants.FillMode.LEFT);
        }
        if ("NM".equals(norm2)) {
            return new ExplicitDecimalFormat(type, minLength, maxLength, TypeFormatConstants.NumberSign.OPTIONAL, true, TypeFormatConstants.FillMode.ZEROES, true, false, false, false);
        }
        if ("SI".equals(norm2)) {
            return new IntegerFormat(type, minLength, maxLength, TypeFormatConstants.NumberSign.UNSIGNED, false, TypeFormatConstants.FillMode.ZEROES);
        }
        if ("DT".equals(norm2)) {
            return new XmlDateFormat(type, minLength, maxLength, XmlDateFormat.Variation.DATE);
        }
        if ("DTM".equals(norm2)) {
            return new XmlDateFormat(type, minLength, maxLength, XmlDateFormat.Variation.DATETIME);
        }
        if ("TM".equals(norm2)) {
            return new XmlDateFormat(type, minLength, maxLength, XmlDateFormat.Variation.TIME);
        }
        if ("FT".equals(norm2) || "GTS".equals(norm2) || "ID".equals(norm2) || "IS".equals(norm2) || "SNM".equals(norm2) || "TN".equals(norm2) || "TX".equals(norm2)) {
            return new GeneralStringFormat(type, minLength, maxLength, TypeFormatConstants.FillMode.LEFT);
        }
        throw new IllegalArgumentException("Unknown HL7 type code " + type);
    }
}

