/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.DelimiterLexer;
import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.EdifactConstants;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;

public class EdifactLexer
extends DelimiterLexer {
    private static final TypeFormat INTER_CONTROL_COUNT_FIELD = EdifactConstants.buildType("n", 0, 6);
    private static final TypeFormat INTER_CONTROL_REF_FIELD = EdifactConstants.buildType("an", 0, 14);
    private final String delimiterDefaults;
    private boolean enforceCharacterSet;

    public EdifactLexer(InputStream is, String delims) {
        super(is, 44);
        this.componentSeparator = (char)58;
        this.dataSeparator = (char)43;
        this.releaseIndicator = 63;
        this.segmentTerminator = (char)39;
        this.repetitionSeparator = 42;
        this.subCompSeparator = -1;
        this.delimiterDefaults = delims;
    }

    public void configure(int subst, boolean enforce) {
        this.substitutionChar = subst;
        this.enforceCharacterSet = enforce;
    }

    @Override
    void handleEscape() throws IOException {
        int value2 = this.reader.read();
        if (value2 >= 0) {
            char chr = (char)value2;
            this.peekToken.append(chr);
        }
    }

    private EdifactConstants.SyntaxVersion firstTimeInit(Map<String, Object> props) throws IOException {
        EdifactConstants.SyntaxVersion version;
        byte[] byts = this.readBytes(3);
        String tag = new String(byts, EdiConstants.ASCII_CHARSET);
        boolean unaseen = false;
        if ("UNA".equals(tag)) {
            char chr;
            byts = this.readBytes(6);
            this.componentSeparator = (char)byts[0];
            this.dataSeparator = (char)byts[1];
            this.releaseIndicator = (char)byts[3];
            this.repetitionSeparator = EdifactConstants.charNonBlank((char)byts[4]);
            this.segmentTerminator = (char)byts[5];
            unaseen = true;
            while ((chr = (char)this.stream.read()) == '\n' || chr == '\r' || chr == ' ') {
            }
            ++this.segmentNumber;
            byts = new byte[3];
            byts[0] = (byte)chr;
            this.readArray(byts, 1);
            tag = new String(byts, EdiConstants.ASCII_CHARSET);
        }
        if (!"UNB".equals(tag)) {
            throw new LexicalException("Message is missing UNB segment (starts with " + tag + ")");
        }
        int ds = this.stream.read();
        String synid = new String(this.readBytes(4), EdiConstants.ASCII_CHARSET);
        props.put("UNB0101", synid);
        EdifactConstants.SyntaxIdentifier syntax = EdifactConstants.EDIFACT_CHARSETS.get(synid);
        int cs = this.stream.read();
        int verch = this.stream.read();
        switch (verch) {
            case 49: 
            case 50: {
                version = EdifactConstants.SyntaxVersion.VERSION2;
                break;
            }
            case 51: {
                version = EdifactConstants.SyntaxVersion.VERSION3;
                break;
            }
            case 52: {
                version = EdifactConstants.SyntaxVersion.VERSION4;
                break;
            }
            default: {
                throw new LexicalException("Unsupported syntax version '" + verch + '\'');
            }
        }
        props.put("UNB0102", Character.toString((char)verch));
        if (!unaseen) {
            String delims = this.delimiterDefaults == null ? version.defaultDelimiters(syntax) : this.delimiterDefaults;
            this.dataSeparator = delims.charAt(0);
            this.componentSeparator = delims.charAt(1);
            this.repetitionSeparator = EdifactConstants.charNonBlank(delims.charAt(2));
            this.segmentTerminator = delims.charAt(3);
            this.releaseIndicator = EdifactConstants.charNonBlank(delims.charAt(4));
        }
        if (ds != this.dataSeparator) {
            throw new LexicalException("Wrong delimiter for syntax version (expected '" + this.dataSeparator + "', found '" + ds + '\'');
        }
        if (cs != this.componentSeparator) {
            throw new LexicalException("Wrong delimiter for syntax version (expected '" + this.componentSeparator + "', found '" + cs + '\'');
        }
        int chr = this.stream.read();
        String codelist = null;
        String charenc = null;
        Charset charset = syntax.defaultCharSet();
        if (version == EdifactConstants.SyntaxVersion.VERSION4 && chr == this.componentSeparator) {
            StringBuilder builder = new StringBuilder();
            while ((chr = this.stream.read()) >= 0 && chr != this.componentSeparator && chr != this.dataSeparator && chr != this.segmentTerminator) {
                builder.append(chr);
            }
            codelist = builder.toString();
            props.put("UNB0103", codelist);
            if (chr == this.componentSeparator) {
                builder.setLength(0);
                while ((chr = this.stream.read()) >= 0 && chr != this.componentSeparator && chr != this.dataSeparator && chr != this.segmentTerminator) {
                    builder.append(chr);
                }
                charenc = builder.toString();
                props.put("UNB0104", charenc);
                if (charenc.length() == 1) {
                    char code = charenc.charAt(0);
                    try {
                        switch (code) {
                            case '1': 
                            case '2': {
                                charset = EdiConstants.ASCII_CHARSET;
                                break;
                            }
                            case '3': {
                                charset = Charset.forName("Cp1148");
                                break;
                            }
                            case '4': {
                                charset = Charset.forName("Cp858");
                                break;
                            }
                            case '7': {
                                charset = EdifactConstants.UTF8;
                                break;
                            }
                            case '8': {
                                charset = Charset.forName("UTF-16");
                                break;
                            }
                            default: {
                                throw new RuntimeException();
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new LexicalException("Unsupported character encoding '" + code + '\'', e);
                    }
                } else if (!"ZZZ".equals(charenc)) {
                    throw new LexicalException("Unknown character encoding code '" + charenc + '\'');
                }
            }
        }
        if (charset == null) {
            throw new LexicalException("Unsupported syntax identifier '" + synid + "' (character encoding not supported)");
        }
        this.allowedChars = this.enforceCharacterSet ? syntax.flags() : null;
        this.reader = new BufferedReader(new InputStreamReader(this.stream, charset));
        ++this.elementNumber;
        this.advance(EdiConstants.ItemType.DATA_ELEMENT);
        return version;
    }

    private EdifactConstants.SyntaxVersion subsequentInit(Map<String, Object> props) throws IOException {
        EdifactConstants.SyntaxVersion version;
        if ("UNA".equals(this.segmentTag())) {
            throw new LexicalException("UNA is only allowed for first interchange");
        }
        if (!"UNB".equals(this.segmentTag())) {
            throw new LexicalException("Message is missing UNB segment (starts with " + this.segmentTag() + ")");
        }
        this.advance();
        String synid = this.tokenBuilder.toString();
        props.put("UNB0101", synid);
        EdifactConstants.SyntaxIdentifier syntax = EdifactConstants.EDIFACT_CHARSETS.get(synid);
        this.advance();
        char verch = this.tokenBuilder.charAt(0);
        switch (verch) {
            case '1': 
            case '2': {
                version = EdifactConstants.SyntaxVersion.VERSION2;
                break;
            }
            case '3': {
                version = EdifactConstants.SyntaxVersion.VERSION3;
                break;
            }
            case '4': {
                version = EdifactConstants.SyntaxVersion.VERSION4;
                break;
            }
            default: {
                throw new LexicalException("Unsupported syntax version '" + verch + '\'');
            }
        }
        props.put("UNB0102", Character.toString(verch));
        while (this.currentType() != EdiConstants.ItemType.DATA_ELEMENT) {
            this.advance();
        }
        this.allowedChars = this.enforceCharacterSet ? syntax.flags() : null;
        return version;
    }

    public boolean isInitialized() {
        return this.reader != null;
    }

    public EdifactConstants.SyntaxVersion init(Map<String, Object> props) throws LexicalException {
        try {
            if (this.reader == null) {
                return this.firstTimeInit(props);
            }
            return this.subsequentInit(props);
        }
        catch (IOException e) {
            throw new LexicalException("Interchange aborted due to error reading header", e);
        }
    }

    public void term(Map<String, Object> props) throws IOException {
        if (!"UNZ".equals(this.segmentTag())) {
            throw new IllegalStateException("not at trailer");
        }
        if (this.nextType() == EdiConstants.ItemType.DATA_ELEMENT) {
            this.advance();
            props.put("UNZ01", INTER_CONTROL_COUNT_FIELD.parse(this));
            if (this.nextType() == EdiConstants.ItemType.DATA_ELEMENT) {
                this.advance();
                props.put("UNZ02", INTER_CONTROL_REF_FIELD.parse(this));
            }
        }
    }

    public static enum InterchangeEndStatus {
        VALID,
        GROUP_COUNT_ERROR,
        CONTROL_NUMBER_ERROR;

    }
}

