/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.formats.ExplicitDecimalFormat;
import com.mulesoft.flatfile.lexical.formats.RestrictedCharacterStringFormat;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public final class EdifactConstants {
    public static final String SYNTAX_IDENTIFIER = "UNB0101";
    public static final String SYNTAX_VERSION_NUMBER = "UNB0102";
    public static final String SERVICE_CODE_LIST = "UNB0103";
    public static final String CHARACTER_ENCODING = "UNB0104";
    public static final String FORCE_UNA = "forceUNA";
    public static final String INTER_CONTROL_COUNT = "UNZ01";
    public static final String INTER_CONTROL_REF = "UNZ02";
    public static final boolean[] levelACharacterSet = new boolean[128];
    public static final boolean[] levelBCharacterSet;
    public static final boolean[] alphaNumerics;
    public static final boolean[] plainAlphas;
    public static final Charset UTF8;
    public static final SyntaxIdentifier LEVELA;
    public static final SyntaxIdentifier LEVELB;
    public static final SyntaxIdentifier LEVELC;
    public static final SyntaxIdentifier LEVELY;
    public static final SyntaxIdentifier IATB;
    public static final Map<String, SyntaxIdentifier> EDIFACT_CHARSETS;
    private static final String basicDelimiters = "+: '?";
    private static final String alternateDelimiters = "\u001d\u001f \u001c ";
    private static final String version4Delimiters = "+:*'?";
    public static final Map<String, SyntaxVersion> EDIFACT_VERSIONS;

    public static void addSyntax(String code, String chname) {
        try {
            Charset chset = Charset.forName(chname);
            SyntaxIdentifier synid = new SyntaxIdentifier(code, chset, null);
            EDIFACT_CHARSETS.put(code, synid);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int charNonBlank(char chr) {
        return chr == ' ' ? -1 : (int)chr;
    }

    public static String typeName(String type, int minLength, int maxLength) {
        if (minLength == maxLength) {
            return type + maxLength;
        }
        if (minLength != 0) {
            throw new IllegalArgumentException("No support for non-zero based size range");
        }
        return type + ".." + maxLength;
    }

    public static TypeFormat buildType(String type, int minLength, int maxLength) {
        String norm2 = type.toLowerCase();
        if ("an".equals(norm2)) {
            return new RestrictedCharacterStringFormat(type, minLength, maxLength, TypeFormatConstants.FillMode.LEFT, alphaNumerics, true);
        }
        if ("n".equals(norm2)) {
            return new ExplicitDecimalFormat(type, minLength, maxLength, TypeFormatConstants.NumberSign.NEGATIVE_ONLY, false, TypeFormatConstants.FillMode.ZEROES, false, true, false, false);
        }
        if ("a".equals(norm2)) {
            return new RestrictedCharacterStringFormat(type, minLength, maxLength, TypeFormatConstants.FillMode.LEFT, plainAlphas, true);
        }
        throw new IllegalArgumentException("Unknown EDIFACT type code " + type);
    }

    static {
        EdiConstants.fillChars('A', 'Z', levelACharacterSet);
        EdiConstants.fillChars('0', '9', levelACharacterSet);
        EdiConstants.setChars(" .,-()/=,+:?!\"%&*;<>".toCharArray(), levelACharacterSet);
        levelBCharacterSet = new boolean[128];
        System.arraycopy(levelACharacterSet, 0, levelBCharacterSet, 0, levelACharacterSet.length);
        EdiConstants.fillChars('a', 'z', levelBCharacterSet);
        EdiConstants.setChars(" .,-()/'+:=?!\"%&*;<>\f\r\u000f".toCharArray(), levelBCharacterSet);
        alphaNumerics = new boolean[128];
        EdiConstants.fillChars(' ', '\u007f', alphaNumerics);
        plainAlphas = new boolean[128];
        EdifactConstants.plainAlphas[32] = true;
        EdiConstants.fillChars('a', 'z', plainAlphas);
        EdiConstants.fillChars('A', 'Z', plainAlphas);
        UTF8 = Charset.forName("UTF-8");
        LEVELA = new SyntaxIdentifier("UNOA", EdiConstants.ASCII_CHARSET, levelACharacterSet);
        LEVELB = new SyntaxIdentifier("UNOB", EdiConstants.ASCII_CHARSET, levelBCharacterSet);
        LEVELC = new SyntaxIdentifier("UNOC", Charset.forName("ISO8859_1"), null);
        LEVELY = new SyntaxIdentifier("UNOY", EdiConstants.ASCII_CHARSET, null);
        IATB = new SyntaxIdentifier("IATB", Charset.forName("ISO8859_1"), null);
        EDIFACT_CHARSETS = new HashMap<String, SyntaxIdentifier>();
        EDIFACT_CHARSETS.put(LEVELA.syntaxCode, LEVELA);
        EDIFACT_CHARSETS.put(LEVELB.syntaxCode, LEVELB);
        EDIFACT_CHARSETS.put(LEVELC.syntaxCode, LEVELC);
        EDIFACT_CHARSETS.put(LEVELY.syntaxCode, LEVELY);
        EDIFACT_CHARSETS.put(IATB.syntaxCode, IATB);
        EdifactConstants.addSyntax("UNOD", "ISO8859_2");
        EdifactConstants.addSyntax("UNOE", "ISO8859_5");
        EdifactConstants.addSyntax("UNOF", "ISO8859_7");
        EdifactConstants.addSyntax("UNOG", "ISO8859_3");
        EdifactConstants.addSyntax("UNOH", "ISO8859_4");
        EdifactConstants.addSyntax("UNOI", "ISO8859_6");
        EdifactConstants.addSyntax("UNOJ", "ISO8859_8");
        EdifactConstants.addSyntax("UNOK", "ISO8859_9");
        EdifactConstants.addSyntax("UNOX", "ISO2375");
        EDIFACT_VERSIONS = new HashMap<String, SyntaxVersion>();
        for (SyntaxVersion version : SyntaxVersion.values()) {
            EDIFACT_VERSIONS.put(version.code(), version);
        }
        EDIFACT_VERSIONS.put("1", SyntaxVersion.VERSION2);
    }

    public static enum SyntaxVersion {
        VERSION2("2"),
        VERSION3("3"),
        VERSION4("4");

        private final String codeValue;

        private SyntaxVersion(String code) {
            this.codeValue = code;
        }

        public String code() {
            return this.codeValue;
        }

        public String defaultDelimiters(SyntaxIdentifier sid) {
            if (this == VERSION4) {
                return EdifactConstants.version4Delimiters;
            }
            if (sid == LEVELA) {
                return EdifactConstants.basicDelimiters;
            }
            return EdifactConstants.alternateDelimiters;
        }
    }

    public static class SyntaxIdentifier {
        private final String syntaxCode;
        private final Charset defaultCharset;
        private final boolean[] characterFlags;

        SyntaxIdentifier(String code, Charset chset, boolean[] flags) {
            this.syntaxCode = code;
            this.defaultCharset = chset;
            this.characterFlags = flags;
        }

        public String code() {
            return this.syntaxCode;
        }

        public Charset defaultCharSet() {
            return this.defaultCharset;
        }

        public boolean[] flags() {
            return this.characterFlags;
        }
    }
}

