/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.BaseFormatter;
import com.mulesoft.lexical.formatstype.CheckAllowedChars;
import com.mulesoft.lexical.formatstype.ExpectedClass;
import com.mulesoft.lexical.formatstype.PadConverter;
import com.mulesoft.lexical.formatstype.SingleConverter;
import com.mulesoft.lexical.formatstype.TruncateConverter;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.validation.LongLengthValidation;
import com.mulesoft.lexical.formatstype.validation.ShortLengthValidation;
import com.mulesoft.lexical.formatstype.validation.TruncateCondition;

public class StringFormatter
extends BaseFormatter<String> {
    private static StringFormatter instance;

    public static StringFormatter getInstance() {
        if (instance == null) {
            instance = new StringFormatter();
        }
        return instance;
    }

    private StringFormatter() {
        this.withPatternMatching(new ExpectedClass<String>(String.class));
        this.withOutputConverter(new TruncateConverter(false).withCondition(new TruncateCondition()));
        this.withOutputConverter(new SingleConverter(new CheckAllowedChars()).withCondition((handler, typeFormat) -> typeFormat.checkAllowedCharacters()));
        this.withOutputConverter(new PadConverter(false));
        this.withValidation(new LongLengthValidation());
        this.withValidation(new ShortLengthValidation());
    }

    @Override
    protected String valueToUseForWrong(Object value, TypeBaseFormat typeFormat, ErrorHandler handler) {
        return value.toString();
    }

    @Override
    protected String valueToUseForNull(TypeBaseFormat typeFormat, ErrorHandler handler) {
        if (handler.applyTruncation(typeFormat)) {
            throw new NullPointerException("Value null");
        }
        return "";
    }

    @Override
    protected String doFormat(String value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        return value;
    }
}

