/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.TypeFormatConverter;
import com.mulesoft.lexical.formatstype.validation.TypeFormatValidation;
import java.util.ArrayList;
import java.util.List;

public abstract class CompositeConverter<A>
implements TypeFormatConverter<A, String> {
    private List<TypeFormatConverter<String, String>> converters = new ArrayList<TypeFormatConverter<String, String>>();
    private List<TypeFormatValidation<String>> validations = new ArrayList<TypeFormatValidation<String>>();
    private boolean applyValidationsBeforeConversions;

    public CompositeConverter() {
        this(false);
    }

    public CompositeConverter(boolean applyValidationsBeforeConversions) {
        this.applyValidationsBeforeConversions = applyValidationsBeforeConversions;
    }

    public void addConverter(TypeFormatConverter<String, String> c) {
        this.converters.add(c);
    }

    public void addValidation(TypeFormatValidation<String> v) {
        this.validations.add(v);
    }

    private void applyValidations(String value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        for (TypeFormatValidation<String> v : this.validations) {
            v.validate(value, typeFormat, handler);
        }
    }

    private String applyConversions(String value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        String converted = value;
        for (TypeFormatConverter<String, String> c : this.converters) {
            converted = c.convert(converted, handler, typeFormat);
        }
        return converted;
    }

    @Override
    public A convert(String value, ErrorHandler handler, TypeBaseFormat typeFormat) throws LexicalException {
        if (this.applyValidationsBeforeConversions) {
            this.applyValidations(value, typeFormat, handler);
        }
        String converted = this.applyConversions(value, typeFormat, handler);
        if (!this.applyValidationsBeforeConversions) {
            this.applyValidations(converted, typeFormat, handler);
        }
        return this.doConvert(converted, handler, typeFormat);
    }

    public abstract A doConvert(String var1, ErrorHandler var2, TypeBaseFormat var3) throws LexicalException;
}

