/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.mule.devkit.tooling.exceptions.GenerationException;
import org.mule.devkit.tooling.generator.Generator;
import org.mule.devkit.tooling.model.Version;

public class IndexPageGenerator
implements Generator {
    private static final String INDEX_FILE_NAME = "index.html";
    private final List<Version> versions;

    public IndexPageGenerator(List<Version> versions) {
        this.versions = versions;
    }

    @Override
    public boolean shouldGenerate() {
        return true;
    }

    @Override
    public void generate(MavenProject project, String workingDir) {
        StringWriter writer = this.renderTemplate(project);
        try {
            PrintWriter printWriter = new PrintWriter(this.getOutputDir(workingDir).toFile());
            printWriter.write(writer.toString());
            printWriter.close();
        }
        catch (IOException e) {
            throw new GenerationException("There was a problem generating the index page: " + e.getMessage(), e);
        }
    }

    @Override
    public Path getOutputDir(String workingDir) {
        return Paths.get(workingDir, "target", INDEX_FILE_NAME);
    }

    private StringWriter renderTemplate(MavenProject project) {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.setProperty("runtime.log.logsystem.class", (Object)NullLogChute.class.getName());
        ve.init();
        VelocityContext context = new VelocityContext();
        context.put("versions", this.orderVersions(this.versions));
        context.put("connectorName", (Object)project.getName());
        context.put("baseURL", (Object)this.repoUrlToDocUrl(project.getScm().getUrl()));
        Template template = ve.getTemplate("index.vm");
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        return writer;
    }

    private List<Version> orderVersions(List<Version> versions) {
        Comparator<Version> versionComparator = Collections.reverseOrder(new Comparator<Version>(){

            @Override
            public int compare(Version o1, Version o2) {
                return o1.getVersion().compareTo(o2.getVersion());
            }
        });
        Collections.sort(versions, versionComparator);
        return versions;
    }

    private String repoUrlToDocUrl(String url) {
        String path;
        try {
            path = new URL(url).getPath();
        }
        catch (MalformedURLException e) {
            throw new GenerationException("Error while transforming URL. Please check the SCM in the pom.xml " + e.getMessage(), e);
        }
        String owner = null;
        String name = null;
        for (String segment : path.split("/")) {
            if (segment.length() <= 0) continue;
            if (owner == null) {
                owner = segment;
                continue;
            }
            if (name != null) break;
            name = segment;
        }
        return String.format("%s.github.io/%s", owner, name);
    }
}

