/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.mule.devkit.tooling.exceptions.GitException;

public class GitService {
    private Git git;
    private String baseBranch;
    private UsernamePasswordCredentialsProvider credentials;

    public GitService(Path baseDir, String user, String pass) {
        try {
            this.git = new Git((Repository)new FileRepository(new File(baseDir.toFile(), ".git")));
            this.baseBranch = this.git.describe().getRepository().getBranch();
            this.credentials = new UsernamePasswordCredentialsProvider(user, pass);
        }
        catch (IOException e) {
            throw new GitException("Error while creating GitService: " + e.getMessage(), e);
        }
    }

    public boolean hasBranch(String branch, ListBranchCommand.ListMode mode) {
        try {
            for (Ref ref : this.git.branchList().setListMode(mode).call()) {
                if (!ref.getName().contains(branch)) continue;
                return true;
            }
        }
        catch (GitAPIException e) {
            throw new GitException(e.getMessage(), (Exception)((Object)e));
        }
        return false;
    }

    private boolean hasLocalBranch(String branch) {
        return this.hasBranch(branch, null);
    }

    public void addAll() {
        try {
            this.git.add().addFilepattern(".").call();
        }
        catch (GitAPIException e) {
            throw new GitException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void push() {
        try {
            ((PushCommand)this.git.push().setCredentialsProvider((CredentialsProvider)this.credentials)).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void pull() {
        try {
            ((PullCommand)this.git.pull().setCredentialsProvider((CredentialsProvider)this.credentials)).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void commit(String message) {
        try {
            this.git.commit().setMessage(message).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void checkoutGhPages() {
        try {
            String branch = "gh-pages";
            if (!this.hasBranch(branch, ListBranchCommand.ListMode.ALL)) {
                this.git.checkout().setName(branch).setCreateBranch(true).call();
                this.cleanDir(this.git.getRepository().getDirectory().getParentFile());
            } else if (this.hasLocalBranch(branch)) {
                this.git.checkout().setName(branch).call();
                if (this.hasBranch(branch, ListBranchCommand.ListMode.REMOTE)) {
                    this.pull();
                }
            } else {
                this.git.checkout().setCreateBranch(true).setName(branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + branch).call();
            }
        }
        catch (GitAPIException e) {
            throw new GitException("Error while doing checkout to gh-pages branch:" + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void checkoutBase() {
        try {
            this.git.checkout().setName(this.baseBranch).call();
        }
        catch (GitAPIException e) {
            throw new GitException("", (Exception)((Object)e));
        }
    }

    public RevCommit stash() {
        try {
            return this.git.stashCreate().call();
        }
        catch (GitAPIException e) {
            throw new GitException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void unstash(RevCommit stash) {
        try {
            this.git.stashApply().setStashRef(stash.getName()).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void cleanDir(File dir, String childModule) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.getName().startsWith(".git") || file.getName().contains("target") || file.getName().equals(childModule)) continue;
                FileUtils.deleteQuietly((File)file);
                this.remove(file.getName());
            }
        }
        this.commit("Deleting previous files");
    }

    public void cleanDir(File dir) {
        this.cleanDir(dir, "");
    }

    public void remove(String pattern) {
        try {
            this.git.rm().addFilepattern(pattern).call();
        }
        catch (GitAPIException e) {
            throw new GitException("Error while removing files: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

