/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.rm.store;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.exception.ReliableMessagingStoreException;
import org.mule.soap.api.message.ReliableMessagingProperties;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.rm.CreateSequenceRequest;
import org.mule.soap.api.rm.ReliableMessagingConfiguration;
import org.mule.soap.api.rm.ReliableMessagingStore;
import org.mule.soap.internal.client.TestSoapClient;
import org.mule.soap.internal.message.TestReliableMessagingProperties;
import org.mule.soap.runtime.rm.RMExecutionTestCase;
import org.mule.soap.runtime.rm.store.RmStoreImpTestCase;
import org.mule.soap.service.RM11Service;
import org.mule.soap.service.RM12Service;
import org.mule.soap.transport.TestHttpDispatcher;

public class NegativeExecuteOperationWithStoreTestCase
extends AbstractSoapServiceTestCase {
    private static final String WSRM_200502 = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    private static final String WSA_200408 = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final String WSRM_10 = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    private static final String WSA_10 = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private RMExecutionTestCase.TestRMHttpDispatcher rmDispatcher;
    private RmStoreImpTestCase.TestReliableMessagingStore testReliableMessagingStore = new RmStoreImpTestCase.TestReliableMessagingStore();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    protected String getServiceClass() {
        return this.soapVersion.equals((Object)SoapVersion.SOAP_11) ? RM11Service.class.getName() : RM12Service.class.getName();
    }

    @Override
    protected void doBefore() throws Exception {
        this.rmDispatcher = new RMExecutionTestCase.TestRMHttpDispatcher(new TestHttpDispatcher());
        this.testReliableMessagingStore.clear();
    }

    @Test
    public void executeOperationWhenSequenceDoesNotExitsOnObjectStore() throws Exception {
        this.expectedException.expect(ReliableMessagingStoreException.class);
        this.expectedException.expectMessage("Unable to update RM sequence");
        ReliableMessagingConfiguration reliableMessaging = ReliableMessagingConfiguration.builder().store((ReliableMessagingStore)this.testReliableMessagingStore).build();
        TestSoapClient client = new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).enableMtom(this.isMtom()).withVersion(this.soapVersion).withSecurities(this.getSecurityStrategies()).withReliableMessaging(reliableMessaging).build());
        String sequenceId = client.createSequence(CreateSequenceRequest.builder().namespaceUri("http://schemas.xmlsoap.org/ws/2005/02/rm").addressingNamespaceUri("http://schemas.xmlsoap.org/ws/2004/08/addressing").build(), this.rmDispatcher);
        this.testReliableMessagingStore.clear();
        client.consume((SoapRequest)SoapRequest.builder().operation("sayHi").content("<con:sayHi xmlns:con=\"http://service.connectors.mule.org/\"><arg0>Gabriel</arg0></con:sayHi>").reliableMessagingProperties((ReliableMessagingProperties)new TestReliableMessagingProperties(sequenceId)).build(), this.rmDispatcher);
    }
}

