/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import com.ctc.wstx.sr.ValidatingStreamReader;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamReader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.soap.internal.generator.AbstractEnricherTestCase;
import org.mule.soap.internal.generator.attachment.SoapAttachmentRequestEnricher;

public class SoapBigSizeRequestEnricherTestCase
extends AbstractEnricherTestCase {
    @Override
    public void before() throws Exception {
        super.before();
        System.getProperties().setProperty("mule.soap.maxAttributeSize", Integer.toString(Integer.MAX_VALUE));
    }

    @Test
    public void enrichMaxSizeOk() throws Throwable {
        InputStream targetStream = Thread.currentThread().getContextClassLoader().getResource("bigsize_request.xml").openStream();
        SoapAttachmentRequestEnricher enricher = new SoapAttachmentRequestEnricher();
        XMLStreamReader request = enricher.enrichRequest("oneWay", targetStream, StandardCharsets.UTF_8.name(), null);
        MatcherAssert.assertThat((Object)((ValidatingStreamReader)request).isEmptyElement(), (Matcher)Matchers.is((Object)false));
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        System.getProperties().remove("mule.soap.maxAttributeSize");
    }
}

