/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.client.EmptyResponseException;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.internal.client.AbstractSoapCxfClient;

public class AbstractSoapCxfClientTestCase
extends AbstractSoapServiceTestCase {
    SoapRequest soapRequest;

    @Before
    public void setup() {
        this.soapRequest = SoapRequest.builder().operation("echo").content(this.testValues.getEchoResquest()).useXMLInitialDeclaration(true).build();
    }

    @Test
    public void testCXFInitialDeclarationConfig() {
        Assert.assertTrue((boolean)this.soapRequest.isUseXMLInitialDeclaration());
    }

    @Test
    public void testCXFInitialDeclarationStreamOutput() throws Exception {
        SoapResponse soapResponse = this.client.consume(this.soapRequest, null);
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoResponse(), soapResponse.getContent());
    }

    @Test
    public void testIllegalEmptyResponse() throws Exception {
        ClientImpl mockClient = (ClientImpl)Mockito.mock(ClientImpl.class);
        ((ClientImpl)Mockito.doThrow(ClientImpl.IllegalEmptyResponseException.class).when((Object)mockClient)).invoke((BindingOperationInfo)ArgumentMatchers.any(BindingOperationInfo.class), (Object[])ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (Exchange)ArgumentMatchers.any());
        this.setMockClient(this.getSoapClient(), mockClient);
        Assert.assertThrows(EmptyResponseException.class, () -> this.client.consume(this.soapRequest, null));
    }

    private AbstractSoapCxfClient getSoapClient() throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = ((Object)((Object)this.client)).getClass().getDeclaredFields()) {
            if (!field.getName().equals("soapClient")) continue;
            field.setAccessible(true);
            return (AbstractSoapCxfClient)field.get((Object)this.client);
        }
        return null;
    }

    private void setMockClient(AbstractSoapCxfClient soapClient, ClientImpl mockClient) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = AbstractSoapCxfClient.class.getDeclaredFields()) {
            if (!field.getName().equals("client")) continue;
            field.setAccessible(true);
            ClientImpl innerClient = (ClientImpl)field.get(soapClient);
            Mockito.when((Object)mockClient.getEndpoint()).thenReturn((Object)innerClient.getEndpoint());
            field.set(soapClient, mockClient);
            break;
        }
    }
}

