/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.wss;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.wss4j.common.crypto.Merlin;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.api.security.WssVerifySignatureSecurityStrategy;
import org.mule.soap.api.security.stores.WssTrustStoreConfiguration;
import org.mule.soap.runtime.wss.AbstractWebServiceSecurityTestCase;
import org.mule.soap.service.VerifyPasswordCallback;

public class WssVerifySignatureTestCase
extends AbstractWebServiceSecurityTestCase {
    @Override
    protected Interceptor buildOutInterceptor() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("action", "Signature");
        props.put("signatureUser", "muleserver");
        props.put("passwordCallbackClass", VerifyPasswordCallback.class.getName());
        String signaturePropRefId = "serverOutSecurityProperties";
        props.put("signaturePropRefId", "serverOutSecurityProperties");
        Properties securityProperties = new Properties();
        securityProperties.put("org.apache.ws.security.crypto.provider", Merlin.class.getName());
        securityProperties.put("org.apache.ws.security.crypto.merlin.keystore.type", "jks");
        securityProperties.put("org.apache.ws.security.crypto.merlin.keystore.password", "mulepassword");
        securityProperties.put("org.apache.ws.security.crypto.merlin.keystore.private.password", "mulepassword");
        securityProperties.put("org.apache.ws.security.crypto.merlin.keystore.alias", "muleserver");
        securityProperties.put("org.apache.ws.security.crypto.merlin.keystore.file", "security/serverKeystore");
        props.put("serverOutSecurityProperties", securityProperties);
        return new WSS4JOutInterceptor(props);
    }

    @Override
    protected List<SecurityStrategy> getSecurityStrategies() {
        WssTrustStoreConfiguration trustStoreConfig = new WssTrustStoreConfiguration("security/trustStore", "mulepassword", "jks");
        return Collections.singletonList(new WssVerifySignatureSecurityStrategy(trustStoreConfig));
    }
}

