/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.wss;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.rm.ReliableMessagingConfiguration;
import org.mule.soap.api.rm.ReliableMessagingStore;
import org.mule.soap.internal.message.DefaultSoapRequest;
import org.mule.soap.runtime.rm.store.RmStoreImpTestCase;
import org.mule.soap.service.Soap11Service;
import org.mule.soap.service.Soap12Service;

@RunWith(value=Parameterized.class)
public abstract class AbstractWebServiceSecurityTestCase
extends AbstractSoapServiceTestCase {
    @Parameterized.Parameter(value=2)
    public boolean withReliableMessaging;

    @Parameterized.Parameters(name="{0}-withRMStore:{2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({SoapVersion.SOAP_11, Soap11Service.class.getName(), false}, {SoapVersion.SOAP_11, Soap11Service.class.getName(), true}, {SoapVersion.SOAP_12, Soap12Service.class.getName(), false}, {SoapVersion.SOAP_12, Soap12Service.class.getName(), true});
    }

    @Override
    protected ReliableMessagingConfiguration getReliableMessagingConfiguration() {
        if (this.withReliableMessaging) {
            RmStoreImpTestCase.TestReliableMessagingStore testReliableMessagingStore = new RmStoreImpTestCase.TestReliableMessagingStore();
            return ReliableMessagingConfiguration.builder().store((ReliableMessagingStore)testReliableMessagingStore).build();
        }
        return super.getReliableMessagingConfiguration();
    }

    @Test
    public void expectedSecuredRequest() throws Exception {
        DefaultSoapRequest req = SoapRequest.builder().content(this.testValues.getEchoResquest()).operation("echo").build();
        this.client.consume((SoapRequest)req, null);
    }
}

