/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.rm;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.api.exception.SoapFaultException;
import org.mule.soap.api.rm.CreateSequenceRequest;
import org.mule.soap.api.transport.DispatcherException;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.api.transport.TransportResponse;

public class NegativeCreateSequenceTestCase
extends AbstractSoapServiceTestCase {
    private static final String namespaceUri = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void failCreateSequenceTest() {
        this.expectedException.expect(SoapFaultException.class);
        this.client.createSequence(CreateSequenceRequest.builder().namespaceUri(namespaceUri).build(), null);
    }

    @Test
    public void failCreateSequenceWithInvalidDispatcherTest() {
        this.expectedException.expect(DispatcherException.class);
        this.client.createSequence(CreateSequenceRequest.builder().namespaceUri(namespaceUri).build(), new FailTransportDispatcher());
    }

    private static class FailTransportDispatcher
    implements TransportDispatcher {
        private FailTransportDispatcher() {
        }

        public TransportResponse dispatch(TransportRequest request) throws DispatcherException {
            throw new DispatcherException("Fail Transport dispatcher", (Throwable)new RuntimeException());
        }
    }
}

