/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.internal.generator.AbstractEnricherTestCase;
import org.mule.soap.internal.generator.EmptyRequestGenerator;

public class EmptyRequestGeneratorTestCase
extends AbstractEnricherTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private EmptyRequestGenerator generator;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.generator = new EmptyRequestGenerator(this.model.getService("TestService").getPort("TestPort"));
    }

    @Test
    public void noParams() throws Exception {
        String request = this.generator.generateRequest("noParams");
        SoapTestUtils.assertSimilarXml(request, this.testValues.getNoParamsRequest());
    }

    @Test
    public void withParams() throws Exception {
        this.exception.expect(BadRequestException.class);
        this.exception.expectMessage("Cannot build default body request for operation [echo], it requires input parameters");
        this.generator.generateRequest("echo");
    }
}

