/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.transport;

import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

abstract class TransportMessage {
    private static final String CONTENT_TYPE = "Content-Type";
    private final InputStream content;
    private final Map<String, String> headers;

    TransportMessage(InputStream content, Map<String, String> headers) {
        this.content = content;
        this.headers = new CaseInsensitiveMap(headers);
    }

    public InputStream getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.getHeader(CONTENT_TYPE).orElse("application/xml");
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Optional<String> getHeader(String headerName) {
        return Optional.ofNullable(this.headers.get(headerName));
    }
}

