/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.server;

import jakarta.servlet.Servlet;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.util.security.Credential;
import org.mule.soap.server.HttpServer;

public class BasicAuthHttpServer
extends HttpServer {
    public static final String USERNAME = "juani";
    public static final String PASSWORD = "changeIt";

    public BasicAuthHttpServer(int port, Interceptor in, Interceptor out, Object serviceInstance) {
        super(port, in, out, serviceInstance);
    }

    @Override
    protected void init() {
        try {
            CXFNonSpringServlet cxf = new CXFNonSpringServlet();
            ServletHolder servlet = new ServletHolder((Servlet)cxf);
            servlet.setName("server");
            servlet.setForcedPath("/");
            ServletContextHandler context = new ServletContextHandler();
            context.setSecurityHandler(this.getBasicAuth());
            context.setContextPath("/");
            context.addServlet(servlet, "/*");
            this.httpServer.setHandler((Handler)context);
            this.httpServer.start();
            this.initializeServer(cxf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SecurityHandler getBasicAuth() {
        UserStore userStore = new UserStore();
        userStore.addUser(USERNAME, Credential.getCredential((String)PASSWORD), new String[]{"user"});
        HashLoginService l = new HashLoginService();
        l.setUserStore(userStore);
        l.setName("private");
        Constraint constraint = new Constraint.Builder().name("__BASIC_AUTH").roles(new String[]{"user"}).authorization(Constraint.Authorization.ALLOWED).build();
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("testRealm");
        csh.addConstraintMapping(cm);
        csh.setLoginService((LoginService)l);
        return csh;
    }
}

