/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.source;

import org.mule.jms.commons.internal.source.push.MessageListenerContext;

import javax.jms.Connection;

/**
 * Cleaner that releases and cleans broker-specific {@link Connection} connection object resources.
 * 
 * @Since 1.3.0
 */
public interface JmsResourceReleaser {

  /**
   * Method exposed and used to perform the connection cleanup. By default, it should be silent, and avoid failures that could
   * provoke the Connection disposal to be made.
   *
   * @param connection the JMS Connection to be cleaned
   */
  void releaseConnection(Connection connection);

  /**
   * Clean message listener registered under the described consumer.
   *
   * @param info Information regarding the message listener necessary to do the cleanup.
   */
  void releaseConsumerMessageListener(MessageListenerContext info);
}
